/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.TimeUnit;

public class TimeUtils {
    public static final String TIMESTAMP_FORMAT = "yyyy-MM-dd' 'HH:mm:ss.SSS";
    private static final ImmutableMap<TimeUnit, String> SHORT_TIMEUNIT_NAMES = ImmutableMap.builder().put((Object)TimeUnit.NANOSECONDS, (Object)"ns").put((Object)TimeUnit.MICROSECONDS, (Object)"\u00b5s").put((Object)TimeUnit.MILLISECONDS, (Object)"ms").put((Object)TimeUnit.SECONDS, (Object)"s").put((Object)TimeUnit.MINUTES, (Object)"min").put((Object)TimeUnit.HOURS, (Object)"hours").put((Object)TimeUnit.DAYS, (Object)"days").build();
    private static final ImmutableMap<TimeUnit, String> LONG_TIMEUNIT_NAMES = ImmutableMap.builder().put((Object)TimeUnit.NANOSECONDS, (Object)"nanoseconds").put((Object)TimeUnit.MICROSECONDS, (Object)"microseconds").put((Object)TimeUnit.MILLISECONDS, (Object)"milliseconds").put((Object)TimeUnit.SECONDS, (Object)"seconds").put((Object)TimeUnit.MINUTES, (Object)"minutes").put((Object)TimeUnit.HOURS, (Object)"hours").put((Object)TimeUnit.DAYS, (Object)"days").build();

    private TimeUtils() {
    }

    public static CharSequence duration(long duration, TimeUnit units, TimeUnitFormat unitFormat) {
        return TimeUtils.appendDuration(new StringBuilder(), duration, units, unitFormat);
    }

    public static String unitStringOf(TimeUnit unit) {
        return (String)SHORT_TIMEUNIT_NAMES.get((Object)unit);
    }

    public static StringBuilder appendDuration(StringBuilder sb, long duration, TimeUnit units, TimeUnitFormat unitFormat) {
        ImmutableMap<TimeUnit, String> unitsFormat;
        Preconditions.checkArgument((duration >= 0L ? 1 : 0) != 0);
        ImmutableMap<TimeUnit, String> immutableMap = unitsFormat = unitFormat == TimeUnitFormat.SHORT ? SHORT_TIMEUNIT_NAMES : LONG_TIMEUNIT_NAMES;
        if (units == TimeUnit.NANOSECONDS && duration < TimeUnit.MICROSECONDS.toNanos(2L)) {
            sb.append(units.toNanos(duration)).append(' ').append((String)unitsFormat.get((Object)TimeUnit.NANOSECONDS));
            return sb;
        }
        if (units.toMicros(duration) < TimeUnit.MILLISECONDS.toMillis(2L) && units.compareTo(TimeUnit.MICROSECONDS) <= 0) {
            sb.append(units.toMicros(duration)).append(' ').append((String)unitsFormat.get((Object)TimeUnit.MICROSECONDS));
            return sb;
        }
        long durationInMillis = units.toMillis(duration);
        if (durationInMillis < TimeUnit.SECONDS.toMillis(2L) && units.compareTo(TimeUnit.MILLISECONDS) <= 0) {
            sb.append(durationInMillis).append(' ').append((String)unitsFormat.get((Object)TimeUnit.MILLISECONDS));
        } else if (durationInMillis < TimeUnit.MINUTES.toMillis(2L) && units.compareTo(TimeUnit.SECONDS) <= 0) {
            sb.append(units.toSeconds(duration)).append(' ').append((String)unitsFormat.get((Object)TimeUnit.SECONDS));
        } else if (durationInMillis < TimeUnit.HOURS.toMillis(2L) && units.compareTo(TimeUnit.MINUTES) <= 0) {
            sb.append(units.toMinutes(duration)).append(' ').append((String)unitsFormat.get((Object)TimeUnit.MINUTES));
        } else if (durationInMillis < TimeUnit.DAYS.toMillis(2L) && units.compareTo(TimeUnit.HOURS) <= 0) {
            sb.append(units.toHours(duration)).append(' ').append((String)unitsFormat.get((Object)TimeUnit.HOURS));
        } else {
            sb.append(units.toDays(duration)).append(' ').append((String)unitsFormat.get((Object)TimeUnit.DAYS));
        }
        return sb;
    }

    public static CharSequence relativeTimestamp(long when, long current) {
        return TimeUtils.appendRelativeTimestamp(new StringBuilder(), when, current);
    }

    public static StringBuilder appendRelativeTimestamp(StringBuilder sb, long when, long current) {
        Preconditions.checkArgument((when > 0L ? 1 : 0) != 0);
        Preconditions.checkArgument((current > 0L ? 1 : 0) != 0);
        SimpleDateFormat iso8601 = new SimpleDateFormat(TIMESTAMP_FORMAT);
        sb.append(iso8601.format(new Date(when)));
        long diff = Math.abs(when - current);
        sb.append(" (");
        TimeUtils.appendDuration(sb, diff, TimeUnit.MILLISECONDS, TimeUnitFormat.LONG);
        sb.append(' ');
        sb.append(when < current ? "ago" : "in the future");
        sb.append(')');
        return sb;
    }

    public static enum TimeUnitFormat {
        SHORT,
        LONG;

    }
}

