/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.util;

import com.google.common.base.Optional;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;

public class Version {
    private final Optional<String> _version;
    private final Optional<String> _buildTime;
    private final Optional<String> _buildNumber;
    private final Optional<String> _branch;

    public Version(Optional<String> buildTime, Optional<String> version, Optional<String> buildNumber, Optional<String> branch) {
        this._buildTime = buildTime;
        this._buildNumber = buildNumber;
        this._version = version;
        this._branch = branch;
    }

    public static Version of(Class<?> clazz) {
        Optional buildTime = Optional.absent();
        Optional version = Optional.absent();
        Optional buildNumber = Optional.absent();
        Optional branch = Optional.absent();
        ProtectionDomain pd = clazz.getProtectionDomain();
        CodeSource cs = pd.getCodeSource();
        URL u = cs.getLocation();
        try (InputStream is = u.openStream();){
            JarInputStream jis = new JarInputStream(is);
            Manifest m = jis.getManifest();
            if (m != null) {
                Attributes as = m.getMainAttributes();
                buildTime = Optional.fromNullable((Object)as.getValue("Build-Time"));
                version = Optional.fromNullable((Object)as.getValue("Implementation-Version"));
                buildNumber = Optional.fromNullable((Object)as.getValue("Implementation-Build"));
                branch = Optional.fromNullable((Object)as.getValue("Implementation-Branch"));
            }
        }
        catch (IOException ignored) {
            // empty catch block
        }
        return new Version((Optional<String>)buildTime, (Optional<String>)version, (Optional<String>)buildNumber, (Optional<String>)branch);
    }

    public static Version of(Object object) {
        return Version.of(object.getClass());
    }

    public String getVersion() {
        return (String)this._version.or((Object)"undefined");
    }

    public String getBuildTime() {
        return (String)this._buildTime.or((Object)"undefined");
    }

    public String getBuildNumber() {
        return (String)this._buildNumber.or((Object)"undefined");
    }

    public String getBranch() {
        return (String)this._branch.or((Object)"undefined");
    }

    public static void main(String[] args) throws IOException {
        System.out.println(Version.of(Version.class).getVersion());
    }
}

