/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.util.backoff;

import java.util.concurrent.Callable;
import org.dcache.util.backoff.IBackoffAlgorithm;
import org.dcache.util.backoff.IBackoffAlgorithmFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackoffController {
    private static final Logger logger = LoggerFactory.getLogger(BackoffController.class);
    private final IBackoffAlgorithmFactory factory;

    public BackoffController(IBackoffAlgorithmFactory factory) {
        this.factory = factory;
    }

    public IBackoffAlgorithm.Status call(Callable<IBackoffAlgorithm.Status> callable) throws Exception {
        IBackoffAlgorithm algorithm = this.factory.getAlgorithm();
        while (true) {
            switch (callable.call()) {
                case SUCCESS: {
                    return IBackoffAlgorithm.Status.SUCCESS;
                }
                case FAILURE: {
                    long wait = algorithm.getWaitDuration();
                    if (wait == -1L) {
                        logger.trace("algorithm returned NO_WAIT");
                        return IBackoffAlgorithm.Status.FAILURE;
                    }
                    this.handleWait(wait);
                }
            }
        }
    }

    protected void handleWait(long wait) throws InterruptedException {
        Thread.sleep(wait);
    }
}

