/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.auth;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.dcache.auth.FQAN;

public abstract class UserAuthBase
implements Serializable {
    private static final long serialVersionUID = -7700110348980815506L;
    public final List<Integer> GIDs = new ArrayList<Integer>();
    public transient long id;
    public String Username;
    public String DN;
    public int priority;
    public int UID = -1;
    public String Home;
    public String Root;
    public String FsRoot;
    public boolean ReadOnly;
    private FQAN fqan;

    public UserAuthBase(String user, boolean readOnly, int uid, int gid, String home, String root, String fsroot) {
        this(user, null, null, readOnly, 0, uid, gid, home, root, fsroot);
    }

    public UserAuthBase(String user, boolean readOnly, int uid, int[] gids, String home, String root, String fsroot) {
        this(user, null, null, readOnly, 0, uid, gids, home, root, fsroot);
    }

    public UserAuthBase(String user, String DN, String fqan, boolean readOnly, int priority, int uid, int gid, String home, String root, String fsroot) {
        this(user, DN, fqan, readOnly, priority, uid, new int[]{gid}, home, root, fsroot);
    }

    public UserAuthBase(String user, String DN, String fqan, boolean readOnly, int priority, int uid, int[] gids, String home, String root, String fsroot) {
        this.Username = user;
        this.DN = DN;
        if (fqan != null) {
            this.fqan = new FQAN(fqan);
        } else if (user != null) {
            this.fqan = new FQAN(user);
        }
        this.ReadOnly = readOnly;
        this.priority = priority;
        this.UID = uid;
        this.Home = home;
        this.Root = root;
        this.FsRoot = fsroot;
        if (gids == null) {
            this.GIDs.add(-1);
        } else {
            for (int gid : gids) {
                this.GIDs.add(gid);
            }
        }
    }

    public UserAuthBase() {
    }

    public String readOnlyStr() {
        if (this.ReadOnly) {
            return "read-only";
        }
        return "read-write";
    }

    public abstract boolean isAnonymous();

    public abstract boolean isWeak();

    public FQAN getFqan() {
        return this.fqan;
    }

    public int hashCode() {
        return Objects.hash(this.Username, this.UID);
    }
}

