/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.commons.stats;

import java.lang.management.ManagementFactory;
import java.util.Formatter;
import java.util.concurrent.TimeUnit;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.dcache.commons.stats.RequestExecutionTimeGaugeMXBean;
import org.dcache.util.TimeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestExecutionTimeGaugeImpl
implements RequestExecutionTimeGaugeMXBean {
    private static final Logger LOG = LoggerFactory.getLogger(RequestExecutionTimeGaugeImpl.class);
    private final String name;
    private long averageExecutionTime = 0L;
    private long minExecutionTime = 0L;
    private long maxExecutionTime = 0L;
    private long executionTimeRMSS = 0L;
    private long updateNum = 0L;
    private long lastExecutionTime = 0L;
    private long startTime;

    public RequestExecutionTimeGaugeImpl(String name, String family) {
        this.name = name;
        String mxName = String.format("%s:type=RequestExecutionTimeGauge,family=%s,name=%s", this.getClass().getPackage().getName(), family, this.name);
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        try {
            ObjectName mxBeanName = new ObjectName(mxName);
            if (!server.isRegistered(mxBeanName)) {
                server.registerMBean(this, mxBeanName);
            }
        }
        catch (MalformedObjectNameException ex) {
            LOG.warn("Failed to create a MXBean with name: {} : {}", (Object)mxName, (Object)ex.toString());
        }
        catch (InstanceAlreadyExistsException | MBeanRegistrationException ex) {
            LOG.warn("Failed to register a MXBean: {}", (Object)ex.toString());
        }
        catch (NotCompliantMBeanException ex) {
            LOG.warn("Failed to create a MXBean: {}", (Object)ex.toString());
        }
        this.startTime = System.currentTimeMillis();
    }

    @Override
    public synchronized void update(long nextExecTime) {
        if (nextExecTime < 0L) {
            LOG.info("possible backwards timeshift detected; discarding invalid data ({})", (Object)nextExecTime);
            return;
        }
        this.minExecutionTime = this.updateNum == 0L ? nextExecTime : Math.min(this.getMinExecutionTime(), nextExecTime);
        this.maxExecutionTime = Math.max(this.getMaxExecutionTime(), nextExecTime);
        this.averageExecutionTime = (this.averageExecutionTime * this.updateNum + nextExecTime) / (this.updateNum + 1L);
        this.executionTimeRMSS = (this.executionTimeRMSS * this.updateNum + nextExecTime * nextExecTime) / (this.updateNum + 1L);
        ++this.updateNum;
        this.lastExecutionTime = nextExecTime;
    }

    @Override
    public synchronized long getAverageExecutionTime() {
        return this.averageExecutionTime;
    }

    @Override
    public synchronized long resetAndGetAverageExecutionTime() {
        long avg = this.getAverageExecutionTime();
        this.reset();
        return avg;
    }

    public synchronized String toString() {
        String aName = this.name;
        if (this.name.length() > 34) {
            aName = aName.substring(0, 34);
        }
        long updatePeriod = System.currentTimeMillis() - this.startTime;
        StringBuilder sb = new StringBuilder();
        try (Formatter formatter = new Formatter(sb);){
            formatter.format("%-34s %,12d\u00b1%,10.2f %,12d %,12d %,12d %,12d %12s", aName, this.averageExecutionTime, this.getStandardError(), this.minExecutionTime, this.maxExecutionTime, this.getStandardDeviation(), this.updateNum, TimeUtils.duration(updatePeriod, TimeUnit.MILLISECONDS, TimeUtils.TimeUnitFormat.SHORT));
        }
        return sb.toString();
    }

    @Override
    public synchronized long getMinExecutionTime() {
        return this.minExecutionTime;
    }

    @Override
    public synchronized long getMaxExecutionTime() {
        return this.maxExecutionTime;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public synchronized double getExecutionTimeRMS() {
        return Math.sqrt(this.executionTimeRMSS);
    }

    @Override
    public synchronized long getStandardDeviation() {
        long deviationSquare = this.executionTimeRMSS - this.averageExecutionTime * this.averageExecutionTime;
        assert (deviationSquare >= 0L);
        return (long)Math.sqrt(this.executionTimeRMSS - this.averageExecutionTime * this.averageExecutionTime);
    }

    @Override
    public synchronized double getStandardError() {
        return (double)this.getStandardDeviation() / Math.sqrt(this.updateNum);
    }

    @Override
    public synchronized long getUpdateNum() {
        return this.updateNum;
    }

    @Override
    public synchronized long getLastExecutionTime() {
        return this.lastExecutionTime;
    }

    @Override
    public synchronized long getStartTime() {
        return this.startTime;
    }

    @Override
    public synchronized void reset() {
        this.startTime = System.currentTimeMillis();
        this.averageExecutionTime = 0L;
        this.minExecutionTime = 0L;
        this.maxExecutionTime = 0L;
        this.executionTimeRMSS = 0L;
        this.lastExecutionTime = 0L;
        this.updateNum = 0L;
    }
}

