/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.commons.stats.rrd;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.security.AccessControlException;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import org.dcache.commons.stats.RequestCounterImpl;
import org.dcache.commons.stats.RequestCounters;
import org.dcache.commons.stats.rrd.RRDRequestCounter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RrdRequestCounters<T> {
    private static final Logger logger = LoggerFactory.getLogger(RrdRequestCounters.class);
    private final Map<T, RRDRequestCounter> rrdcounters = new HashMap<T, RRDRequestCounter>();
    private RRDRequestCounter totalRequestCounter;
    private final RequestCounters<T> requestCounters;
    private static final Timer rrdTimer = new Timer("RrdRequestCounters", true);
    private final String rrdDir;
    private TimerTask updateRrd;
    private TimerTask updateRrdGraphs;
    private long updatePeriodSecs = 60L;
    private long graphPeriodSecs = 300L;

    public RrdRequestCounters(RequestCounters<T> requestCounters, String rrdDir) throws IOException {
        this(requestCounters, rrdDir, 60L, 300L);
    }

    public RrdRequestCounters(RequestCounters<T> requestCounters, String rrdDir, long updatePeriodSecs, long graphPeriodSecs) throws IOException {
        logger.debug("RrdRequestCounters(" + requestCounters + ", " + rrdDir);
        this.requestCounters = requestCounters;
        this.rrdDir = rrdDir;
        File dir = new File(rrdDir);
        if (!dir.exists()) {
            dir.mkdir();
        }
        if (!(dir.exists() && dir.canRead() && dir.canWrite() && dir.canExecute())) {
            throw new AccessControlException("directory " + dir + " does not exists or is not accessable");
        }
        this.updatePeriodSecs = updatePeriodSecs;
        this.graphPeriodSecs = graphPeriodSecs;
        this.totalRequestCounter = new RRDRequestCounter(rrdDir, requestCounters.getTotalRequestCounter(), updatePeriodSecs);
        this.updateIndex();
    }

    public synchronized void startRrdUpdates() {
        if (this.updateRrd != null) {
            throw new IllegalStateException("RRD Updates are started");
        }
        this.updateRrd = new TimerTask(){

            @Override
            public void run() {
                logger.debug("RrdRequestCounters updateRrd running updateRrds()");
                try {
                    RrdRequestCounters.this.updateRrds();
                    logger.debug("RrdRequestCounters updateRrd updateRrds() is done");
                }
                catch (Throwable t) {
                    logger.error("updateRrds", t);
                }
            }
        };
        rrdTimer.schedule(this.updateRrd, this.updatePeriodSecs * 1000L, this.updatePeriodSecs * 1000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateRrds() throws IOException {
        boolean countersAdded = false;
        logger.debug("updateRrds() for " + this.requestCounters);
        RequestCounters<T> requestCounters = this.requestCounters;
        synchronized (requestCounters) {
            for (T key : this.requestCounters.keySet()) {
                logger.debug("updatePrds(): key is " + key);
                if (this.rrdcounters.containsKey(key)) continue;
                RequestCounterImpl requestCounter = this.requestCounters.getCounter(key);
                logger.debug("updatePrds(): creating RRDRequestCounter for " + requestCounter);
                RRDRequestCounter rrdRequestCounter = new RRDRequestCounter(this.rrdDir, requestCounter, this.updatePeriodSecs);
                this.rrdcounters.put(key, rrdRequestCounter);
                countersAdded = true;
            }
        }
        for (RRDRequestCounter rrdRequestCounter : this.rrdcounters.values()) {
            logger.debug("updateRrds(): calling rrdRequestCounter.update()");
            rrdRequestCounter.update();
        }
        logger.debug("updateRrds(): calling totalRequestCounter.update()");
        this.totalRequestCounter.update();
        if (countersAdded) {
            this.updateIndex();
        }
    }

    public Set<T> keySet() {
        return this.rrdcounters.keySet();
    }

    public RRDRequestCounter getRrdCounter(T key) {
        RrdRequestCounters rrdRequestCounters = this;
        synchronized (rrdRequestCounters) {
            if (this.rrdcounters.containsKey(key)) {
                return this.rrdcounters.get(key);
            }
            throw new NoSuchElementException("counter with name " + key + " is not defined in rrdcounters");
        }
    }

    public void plotGraphs() throws IOException {
        for (T key : this.rrdcounters.keySet()) {
            RRDRequestCounter rrdRequestCounter = this.rrdcounters.get(key);
            logger.debug("plotGraphs(): calling rrdRequestCounter.graph()");
            rrdRequestCounter.graph();
            logger.debug("plotGraphs(): rrdRequestCounter.graph() returned");
        }
        logger.debug("plotGraphs(): calling totalRequestCounter.graph()");
        this.totalRequestCounter.graph();
        logger.debug("plotGraphs(): totalRequestCounter.graph() returned");
    }

    public synchronized void startRrdGraphPlots() {
        if (this.updateRrdGraphs != null) {
            throw new IllegalStateException("RRD Graph Updates are started");
        }
        this.updateRrdGraphs = new TimerTask(){

            @Override
            public void run() {
                try {
                    logger.debug("RrdRequestCounters updateRrd running plotGraphs()");
                    RrdRequestCounters.this.plotGraphs();
                }
                catch (Throwable t) {
                    logger.error("plotGraphs", t);
                }
            }
        };
        rrdTimer.schedule(this.updateRrdGraphs, this.updatePeriodSecs * 1000L, this.graphPeriodSecs * 1000L);
    }

    public synchronized void stopRrdUpdates() {
        if (this.updateRrd != null) {
            this.updateRrd.cancel();
            this.updateRrd = null;
        }
    }

    public synchronized void stopRrdGraphPlots() {
        if (this.updateRrdGraphs != null) {
            this.updateRrdGraphs.cancel();
            this.updateRrdGraphs = null;
        }
    }

    private void updateIndex() throws IOException {
        File index = new File(this.rrdDir, "index.html");
        String indexHtml = this.getIndexHtml();
        FileWriter fw = new FileWriter(index);
        fw.write(indexHtml);
        fw.close();
    }

    private String getIndexHtml() {
        StringBuilder sb = new StringBuilder();
        sb.append("<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">\n");
        sb.append("<html>\n");
        sb.append("<head>\n");
        sb.append("  <meta content=\"text/html; charset=ISO-8859-1\"\n");
        sb.append(" http-equiv=\"content-type\">\n");
        sb.append("  <title>Request Rate Graphs Index for ");
        sb.append(this.requestCounters.getName());
        sb.append(" </title>\n");
        sb.append("</head>\n");
        sb.append("<body>\n");
        sb.append("  <h1>Request Rate Graphs Index for ");
        sb.append(this.requestCounters.getName());
        sb.append(" </h1>\n");
        sb.append("  <table> \n");
        sb.append("  <tr> <td> \n");
        for (T key : this.rrdcounters.keySet()) {
            sb.append("  <tr> <td> \n");
            String nextHtml = this.rrdcounters.get(key).getRrdGraphicsHtmlFileName();
            sb.append("<a href=\"");
            sb.append(nextHtml);
            sb.append("\">");
            sb.append(nextHtml);
            sb.append("</a>\n");
            sb.append("  </td> </tr> \n");
        }
        sb.append("  <tr> <td> \n");
        String nextHtml = this.totalRequestCounter.getRrdGraphicsHtmlFileName();
        sb.append("<a href=\"");
        sb.append(nextHtml);
        sb.append("\">");
        sb.append(nextHtml);
        sb.append("</a>\n");
        sb.append("  </td> </tr> \n");
        sb.append("</body>");
        sb.append("</html>");
        return sb.toString();
    }

    public static void main(String[] args) throws Exception {
        String dir = args[0];
        RequestCounters<String> rcs = new RequestCounters<String>(dir);
        Random r = new Random();
        rcs.incrementRequests("counter1", r.nextInt(100));
        rcs.incrementRequests("counter2", r.nextInt(100));
        RrdRequestCounters rrdrcs = new RrdRequestCounters(rcs, dir, 10L, 20L);
        rrdrcs.startRrdUpdates();
        rrdrcs.startRrdGraphPlots();
        while (true) {
            Thread.sleep(10000L);
            rcs.incrementRequests("counter1", r.nextInt(300));
            rcs.incrementFailed("counter1", r.nextInt(200));
            rcs.incrementRequests("counter2", r.nextInt(300));
            rcs.incrementFailed("counter2", r.nextInt(200));
            System.out.println("updated counters:\n" + rcs);
        }
    }

    public RRDRequestCounter getTotalRequestCounter() {
        return this.totalRequestCounter;
    }
}

