/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.commons.util;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Strings {
    private static final Logger LOGGER = LoggerFactory.getLogger(Strings.class);
    private static final String ANSI_ESCAPE = "\u001b[";
    private static final String[] ZERO_LENGTH_STRING_ARRAY = new String[0];
    private static final String INFINITY = "infinity";
    public static final Function<Object, Object> TO_STRING = new Function<Object, Object>(){

        public Object apply(Object input) {
            return Strings.toString(input);
        }
    };
    private static final Function<Class<?>, String> GET_SIMPLE_NAME = new Function<Class<?>, String>(){

        public String apply(Class<?> c) {
            return c.getSimpleName();
        }
    };

    public static String[] splitArgumentString(String argumentString) {
        LOGGER.debug("splitting argument string {}", (Object)argumentString);
        if (argumentString == null) {
            return ZERO_LENGTH_STRING_ARRAY;
        }
        argumentString = argumentString.trim();
        Pattern regex = Pattern.compile("\"([^\"]*)\"|'([^']*)'|([^\\s]+)");
        Matcher regexMatcher = regex.matcher(argumentString);
        ArrayList<String> matchList = new ArrayList<String>();
        while (regexMatcher.find()) {
            String groupMatch;
            if (regexMatcher.group(1) != null) {
                groupMatch = regexMatcher.group(1);
                LOGGER.debug("first group matched [{}]", (Object)groupMatch);
                matchList.add(groupMatch);
                continue;
            }
            if (regexMatcher.group(2) != null) {
                groupMatch = regexMatcher.group(2);
                LOGGER.debug("second group matched [{}]", (Object)groupMatch);
                matchList.add(groupMatch);
                continue;
            }
            if (regexMatcher.group(3) == null) continue;
            groupMatch = regexMatcher.group(3);
            LOGGER.debug("third group matched [{}]", (Object)groupMatch);
            matchList.add(groupMatch);
        }
        return matchList.toArray(new String[matchList.size()]);
    }

    public static int plainLength(String s) {
        int length;
        int plainLength = length = s.length();
        int i = s.indexOf(ANSI_ESCAPE);
        while (i > -1) {
            plainLength -= ANSI_ESCAPE.length();
            if ((i += ANSI_ESCAPE.length()) < length) {
                while (i + 1 < length && (s.charAt(i) < '@' || s.charAt(i) > '~')) {
                    ++i;
                    --plainLength;
                }
                ++i;
                --plainLength;
            }
            i = s.indexOf(ANSI_ESCAPE, i);
        }
        return plainLength;
    }

    private static int indexOfNextWrap(char[] chars, int fromIndex, int wrapLength) {
        int lastWrap = -1;
        int max = fromIndex + wrapLength;
        int length = chars.length;
        for (int i = fromIndex; i < length && (i <= max || lastWrap == -1); ++i) {
            if (Character.isWhitespace(chars[i])) {
                lastWrap = i;
                continue;
            }
            if (chars[i] != '\u001b' || i >= length || chars[i + 1] != '[') continue;
            i += 2;
            max += 2;
            while (i < length && (chars[i] < '@' || chars[i] > '~')) {
                ++max;
                ++i;
            }
            ++max;
        }
        return length <= max || lastWrap == -1 ? length : lastWrap;
    }

    public static String wrap(String indent, String str, int wrapLength) {
        int offset = 0;
        StringBuilder out = new StringBuilder(str.length());
        char[] chars = str.toCharArray();
        int length = chars.length;
        while (offset < length) {
            int spaceToWrapAt;
            int eop;
            for (eop = offset; eop < length && chars[eop] != '\n'; ++eop) {
            }
            while ((spaceToWrapAt = Strings.indexOfNextWrap(chars, offset, wrapLength)) < eop) {
                out.append(indent);
                out.append(chars, offset, spaceToWrapAt - offset);
                out.append('\n');
                for (offset = spaceToWrapAt + 1; offset < length && chars[offset] == ' '; ++offset) {
                }
            }
            out.append(indent).append(chars, offset, eop - offset).append('\n');
            offset = eop + 1;
        }
        return out.toString();
    }

    public static String toStringSignature(Method m, Character c) {
        StringBuilder sb = new StringBuilder();
        sb.append(m.getName());
        sb.append("(");
        sb.append(Joiner.on((char)c.charValue()).join(Iterables.transform(Arrays.asList(m.getParameterTypes()), GET_SIMPLE_NAME)));
        sb.append(')');
        return sb.toString();
    }

    public static int parseInt(String s) throws NumberFormatException {
        return s.equals(INFINITY) ? Integer.MAX_VALUE : Integer.parseInt(s);
    }

    public static long parseLong(String s) throws NumberFormatException {
        return s.equals(INFINITY) ? Long.MAX_VALUE : Long.parseLong(s);
    }

    public static long parseTime(String s, TimeUnit unit) {
        return s.equals(INFINITY) ? Long.MAX_VALUE : TimeUnit.MILLISECONDS.convert(Long.parseLong(s), unit);
    }

    public static String toString(Object value) {
        if (value == null) {
            return "";
        }
        if (value.getClass().isArray()) {
            Class<?> componentType = value.getClass().getComponentType();
            if (componentType == Boolean.TYPE) {
                return Arrays.toString((boolean[])value);
            }
            if (componentType == Byte.TYPE) {
                return Arrays.toString((byte[])value);
            }
            if (componentType == Character.TYPE) {
                return Arrays.toString((char[])value);
            }
            if (componentType == Double.TYPE) {
                return Arrays.toString((double[])value);
            }
            if (componentType == Float.TYPE) {
                return Arrays.toString((float[])value);
            }
            if (componentType == Integer.TYPE) {
                return Arrays.toString((int[])value);
            }
            if (componentType == Long.TYPE) {
                return Arrays.toString((long[])value);
            }
            if (componentType == Short.TYPE) {
                return Arrays.toString((short[])value);
            }
            return Arrays.deepToString((Object[])value);
        }
        return value.toString();
    }

    public static String toMultilineString(Object value) {
        if (value == null) {
            return "";
        }
        if (value.getClass().isArray()) {
            Class<?> componentType = value.getClass().getComponentType();
            if (componentType == Boolean.TYPE) {
                return Arrays.toString((boolean[])value);
            }
            if (componentType == Byte.TYPE) {
                return Arrays.toString((byte[])value);
            }
            if (componentType == Character.TYPE) {
                return Arrays.toString((char[])value);
            }
            if (componentType == Double.TYPE) {
                return Arrays.toString((double[])value);
            }
            if (componentType == Float.TYPE) {
                return Arrays.toString((float[])value);
            }
            if (componentType == Integer.TYPE) {
                return Arrays.toString((int[])value);
            }
            if (componentType == Long.TYPE) {
                return Arrays.toString((long[])value);
            }
            if (componentType == Short.TYPE) {
                return Arrays.toString((short[])value);
            }
            return Joiner.on((char)'\n').join(Iterables.transform(Arrays.asList((Object[])value), TO_STRING));
        }
        return value.toString();
    }
}

