/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.util;

import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.escape.CharEscaperBuilder;
import com.google.common.escape.Escaper;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.Logger;

public class NetLoggerBuilder {
    private static final ThreadLocal<SimpleDateFormat> TS_FORMAT = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        }
    };
    private final StringBuilder s = new StringBuilder(256);
    private boolean omitNullValues;
    private Level level;
    private static final Escaper AS_QUOTED_VALUE = new CharEscaperBuilder().addEscape('\\', "\\\\").addEscape('\"', "\\\"").addEscape('\n', "\\n").addEscape('\r', "\\r").toEscaper();
    private static final CharMatcher NEEDS_QUOTING = CharMatcher.anyOf((CharSequence)" \"\n\r");

    private String getTimestamp() {
        return TS_FORMAT.get().format(new Date());
    }

    public NetLoggerBuilder(String event) {
        this.s.append("ts=").append(this.getTimestamp()).append(' ');
        this.s.append("event=").append(event);
    }

    public NetLoggerBuilder(Level level, String event) {
        this.level = level;
        this.s.append("level=").append((Object)level).append(' ');
        this.s.append("ts=").append(this.getTimestamp()).append(' ');
        this.s.append("event=").append(event);
    }

    public NetLoggerBuilder omitNullValues() {
        this.omitNullValues = true;
        return this;
    }

    public NetLoggerBuilder add(String name, Object value) {
        if (!this.omitNullValues || value != null) {
            this.s.append(' ').append(name).append('=');
            if (value != null) {
                String stringValue = value.toString();
                if (NEEDS_QUOTING.matchesAnyOf((CharSequence)stringValue)) {
                    this.s.append('\"').append(AS_QUOTED_VALUE.escape(stringValue)).append('\"');
                } else {
                    this.s.append(stringValue);
                }
            }
        }
        return this;
    }

    public NetLoggerBuilder addInQuotes(String name, Object value) {
        if (!this.omitNullValues || value != null) {
            this.s.append(' ').append(name).append('=');
            if (value != null) {
                this.s.append('\"').append(AS_QUOTED_VALUE.escape(value.toString())).append('\"');
            }
        }
        return this;
    }

    public NetLoggerBuilder add(String name, boolean value) {
        return this.add(name, String.valueOf(value));
    }

    public NetLoggerBuilder add(String name, char value) {
        return this.add(name, String.valueOf(value));
    }

    public NetLoggerBuilder add(String name, double value) {
        return this.add(name, String.valueOf(value));
    }

    public NetLoggerBuilder add(String name, float value) {
        return this.add(name, String.valueOf(value));
    }

    public NetLoggerBuilder add(String name, int value) {
        return this.add(name, String.valueOf(value));
    }

    public NetLoggerBuilder add(String name, long value) {
        return this.add(name, String.valueOf(value));
    }

    public String toString() {
        return this.s.toString();
    }

    public void toLogger(Logger logger) {
        Preconditions.checkState((this.level != null ? 1 : 0) != 0, (Object)"Cannot log to logger without a level.");
        String line = this.toString();
        switch (this.level) {
            case ERROR: {
                logger.error(line);
                break;
            }
            case WARN: {
                logger.warn(line);
                break;
            }
            case INFO: {
                logger.info(line);
                break;
            }
            case DEBUG: {
                logger.debug(line);
                break;
            }
            case TRACE: {
                logger.trace(line);
            }
        }
    }

    public static enum Level {
        ERROR,
        WARN,
        INFO,
        DEBUG,
        TRACE;

    }
}

