/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.util;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Iterator;

public class RegexUtils {
    public static final String CASE_INSENSITIVE = "CASE_INSENSITIVE";
    public static final String MULTILINE = "MULTILINE";
    public static final String DOTALL = "DOTALL";
    public static final String UNICODE_CASE = "UNICODE_CASE";
    public static final String CANON_EQ = "CANON_EQ";
    public static final String LITERAL = "LITERAL";
    public static final String COMMENTS = "COMMENTS";
    public static final String UNIX_LINES = "UNIX_LINES";
    public static final ImmutableSet<String> FLAG_VALUES = new ImmutableSet.Builder().add((Object)"CASE_INSENSITIVE").add((Object)"MULTILINE").add((Object)"DOTALL").add((Object)"UNICODE_CASE").add((Object)"CANON_EQ").add((Object)"LITERAL").add((Object)"COMMENTS").add((Object)"UNIX_LINES").build();

    public static int parseFlags(String flags) {
        String[] split;
        if (flags == null) {
            return 0;
        }
        int value = 0;
        block20: for (String s : split = flags.split("[|]")) {
            switch (s.trim()) {
                case "CASE_INSENSITIVE": {
                    value |= 2;
                    continue block20;
                }
                case "MULTILINE": {
                    value |= 8;
                    continue block20;
                }
                case "DOTALL": {
                    value |= 0x20;
                    continue block20;
                }
                case "UNICODE_CASE": {
                    value |= 0x40;
                    continue block20;
                }
                case "CANON_EQ": {
                    value |= 0x80;
                    continue block20;
                }
                case "LITERAL": {
                    value |= 0x10;
                    continue block20;
                }
                case "COMMENTS": {
                    value |= 4;
                    continue block20;
                }
                case "UNIX_LINES": {
                    value |= 1;
                }
            }
        }
        return value;
    }

    public static String flagsToString(int flags) {
        Iterator it;
        StringBuilder result = new StringBuilder();
        ArrayList<String> options = new ArrayList<String>();
        if ((flags & 2) == 2) {
            options.add(CASE_INSENSITIVE);
        }
        if ((flags & 8) == 8) {
            options.add(MULTILINE);
        }
        if ((flags & 0x20) == 32) {
            options.add(UNIX_LINES);
        }
        if ((flags & 0x40) == 64) {
            options.add(UNICODE_CASE);
        }
        if ((flags & 0x80) == 128) {
            options.add(CANON_EQ);
        }
        if ((flags & 0x10) == 16) {
            options.add(LITERAL);
        }
        if ((flags & 4) == 4) {
            options.add(COMMENTS);
        }
        if ((flags & 1) == 1) {
            options.add(UNIX_LINES);
        }
        if ((it = options.iterator()).hasNext()) {
            result.append((String)it.next());
        } else {
            return null;
        }
        while (it.hasNext()) {
            result.append(" | ").append((String)it.next());
        }
        return result.toString();
    }
}

