/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.auth;

import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.security.Principal;

public class OidcSubjectPrincipal
implements Principal,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String _sub;

    public OidcSubjectPrincipal(String sub) {
        Preconditions.checkArgument((boolean)CharMatcher.ASCII.matchesAllOf((CharSequence)sub), (Object)"OpenId \"sub\" is not ASCII encoded");
        Preconditions.checkArgument((sub.length() <= 255 ? 1 : 0) != 0, (Object)"OpenId \"sub\" must not exceed 255 ASCII characters");
        this._sub = sub;
    }

    @Override
    public String getName() {
        return this._sub;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof OidcSubjectPrincipal)) {
            return false;
        }
        OidcSubjectPrincipal other = (OidcSubjectPrincipal)obj;
        return this._sub.equals(other._sub);
    }

    @Override
    public int hashCode() {
        return this._sub.hashCode();
    }

    @Override
    public String toString() {
        return "OidcSubjectPrincipal[" + this._sub + "]";
    }
}

