/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.auth;

import com.google.common.base.Joiner;
import java.util.Set;
import java.util.TreeSet;
import org.dcache.auth.UserAuthBase;

public class UserAuthRecord
extends UserAuthBase {
    private static final long serialVersionUID = 2212212275053022221L;
    public Set<String> principals;

    public UserAuthRecord(String user, String DN, String fqan, boolean readOnly, int priority, int uid, int[] GIDs, String home, String root, String fsroot, Set<String> principals) {
        super(user, DN, fqan, readOnly, priority, uid, GIDs, home, root, fsroot);
        this.principals = new TreeSet<String>(principals);
    }

    public UserAuthRecord(String user, String DN, String fqan, boolean readOnly, int priority, int uid, int gid, String home, String root, String fsroot, Set<String> principals) {
        super(user, DN, fqan, readOnly, priority, uid, gid, home, root, fsroot);
        this.principals = new TreeSet<String>(principals);
    }

    public UserAuthRecord(String user, boolean readOnly, int uid, int[] GIDs, String home, String root, String fsroot, Set<String> principals) {
        super(user, readOnly, uid, GIDs, home, root, fsroot);
        this.principals = new TreeSet<String>(principals);
    }

    public UserAuthRecord(String user, boolean readOnly, int uid, int gid, String home, String root, String fsroot, Set<String> principals) {
        super(user, readOnly, uid, gid, home, root, fsroot);
        this.principals = new TreeSet<String>(principals);
    }

    public UserAuthRecord() {
    }

    public void appendToStringBuffer(StringBuffer sb) {
        sb.append(this.Username);
        if (this.ReadOnly) {
            sb.append(" read-only");
        } else {
            sb.append(" read-write");
        }
        sb.append(' ').append(this.UID).append(' ');
        sb.append(Joiner.on((String)",").skipNulls().join(this.GIDs.iterator())).append(' ');
        sb.append(this.Home).append(' ');
        sb.append(this.Root).append(' ');
        sb.append(this.FsRoot).append('\n');
        if (this.principals != null) {
            for (String principal : this.principals) {
                sb.append("  ").append(principal).append('\n');
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.Username);
        sb.append(' ').append(this.DN);
        sb.append(' ').append(this.getFqan());
        if (this.ReadOnly) {
            sb.append(" read-only");
        } else {
            sb.append(" read-write");
        }
        sb.append(' ').append(this.UID).append(' ');
        sb.append(this.GIDs).append(' ');
        sb.append(this.Home).append(' ');
        sb.append(this.Root).append(' ');
        sb.append(this.FsRoot).append('\n');
        if (this.principals != null) {
            for (String principal : this.principals) {
                sb.append("  ").append(principal).append('\n');
            }
        }
        return sb.toString();
    }

    public String toDetailedString() {
        StringBuilder sb = new StringBuilder(" User Authentication Record for ");
        sb.append(this.Username).append(" :\n");
        sb.append("             DN = ").append(this.DN).append('\n');
        sb.append("           FQAN = ").append(this.getFqan()).append('\n');
        sb.append("      read-only = ").append(this.readOnlyStr()).append("\n");
        sb.append("            UID = ").append(this.UID).append('\n');
        sb.append("           GIDs = ");
        sb.append(Joiner.on((String)",").skipNulls().join(this.GIDs.iterator())).append('\n');
        sb.append("           Home = ").append(this.Home).append('\n');
        sb.append("           Root = ").append(this.Root).append('\n');
        sb.append("         FsRoot = ").append(this.FsRoot).append('\n');
        if (this.principals != null) {
            sb.append("         Secure Ids accepted by this user :\n");
            for (String principal : this.principals) {
                sb.append("    SecureId  = \"").append(principal).append("\"\n");
            }
        }
        return sb.toString();
    }

    @Override
    public boolean isAnonymous() {
        return false;
    }

    @Override
    public boolean isWeak() {
        return false;
    }

    public boolean hasSecureIdentity(String p) {
        if (this.principals != null) {
            return this.principals.contains(p);
        }
        return false;
    }

    public boolean isValid() {
        return this.Username != null;
    }

    public void addSecureIdentity(String id) {
        this.principals.add(id);
    }

    public void addSecureIdentities(Set<String> ids) {
        this.principals.addAll(ids);
    }

    public void removeSecureIdentities(Set<String> ids) {
        this.principals.removeAll(ids);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof UserAuthRecord)) {
            return false;
        }
        UserAuthRecord r = (UserAuthRecord)obj;
        return this.Username.equals(r.Username) && this.ReadOnly == r.ReadOnly && this.UID == r.UID && this.GIDs.equals(r.GIDs) && this.Home.equals(r.Home) && this.Root.equals(r.Root) && this.FsRoot.equals(r.FsRoot) && this.getFqan().equals(r.getFqan());
    }
}

