/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.auth.attributes;

import com.google.common.collect.ImmutableSet;
import diskCacheV111.util.FsPath;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.dcache.auth.attributes.Activity;
import org.dcache.auth.attributes.Restriction;

public class PrefixRestriction
implements Restriction {
    private static final long serialVersionUID = 7073397935939729478L;
    private ImmutableSet<FsPath> prefixes;

    public PrefixRestriction(FsPath ... prefixes) {
        this.prefixes = ImmutableSet.copyOf((Object[])prefixes);
    }

    @Override
    public boolean isRestricted(Activity activity, FsPath path) {
        for (FsPath prefix : this.prefixes) {
            if (!path.hasPrefix(prefix) && (activity != Activity.READ_METADATA || !prefix.hasPrefix(path))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isRestricted(Activity activity, FsPath directory, String child) {
        return this.isRestricted(activity, directory.child(child));
    }

    public int hashCode() {
        return PrefixRestriction.class.hashCode() ^ this.prefixes.hashCode();
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof PrefixRestriction && ((PrefixRestriction)other).prefixes.equals(this.prefixes);
    }

    @Override
    public boolean isSubsumedBy(Restriction other) {
        return other instanceof PrefixRestriction && ((PrefixRestriction)other).subsumes(this);
    }

    private boolean subsumes(PrefixRestriction restriction) {
        for (FsPath prefix : this.prefixes) {
            if (!restriction.isRestricted(prefix)) continue;
            return false;
        }
        return true;
    }

    private boolean isRestricted(FsPath path) {
        for (FsPath prefix : this.prefixes) {
            if (!path.hasPrefix(prefix)) continue;
            return false;
        }
        return true;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        int count = stream.readInt();
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (int i = 0; i < count; ++i) {
            builder.add((Object)FsPath.create(stream.readObject().toString()));
        }
        this.prefixes = builder.build();
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.writeInt(this.prefixes.size());
        for (FsPath prefix : this.prefixes) {
            stream.writeObject(prefix.toString());
        }
    }
}

