/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.commons.stats;

import com.google.common.base.Function;
import com.google.common.collect.Ordering;
import java.lang.reflect.Method;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.dcache.commons.stats.RequestCounter;
import org.dcache.commons.stats.RequestCounterImpl;
import org.dcache.commons.util.Strings;

public class RequestCounters<T> {
    private final String name;
    private final boolean autoCreate;
    private final Map<T, RequestCounterImpl> counters = new HashMap<T, RequestCounterImpl>();
    private static final Ordering<RequestCounter> ORDERING = Ordering.natural().onResultOf((Function)new Function<RequestCounter, String>(){

        public String apply(RequestCounter counter) {
            return counter.getName();
        }
    });

    public RequestCounters(String name) {
        this(name, true);
    }

    public RequestCounters(String name, boolean autoCreate) {
        this.name = name;
        this.autoCreate = autoCreate;
    }

    public String getName() {
        return this.name;
    }

    public void addCounter(T key) {
        String counterName;
        if (key instanceof Class) {
            Class ckey = (Class)key;
            counterName = ckey.getSimpleName();
        } else if (key instanceof Method) {
            Method mkey = (Method)key;
            counterName = Strings.toStringSignature(mkey, Character.valueOf('|'));
        } else {
            counterName = key.toString();
        }
        this.addCounter(key, counterName);
    }

    public synchronized void addCounter(T key, String name) {
        if (this.counters.containsKey(key)) {
            return;
        }
        RequestCounterImpl counter = new RequestCounterImpl(name, this.name);
        this.counters.put(key, counter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder sb = new StringBuilder();
        try (Formatter formatter = new Formatter(sb);){
            formatter.format("%-36s %9s %9s", this.name, "requests", "failed");
            int totalRequests = 0;
            int totalFailed = 0;
            RequestCounters requestCounters = this;
            synchronized (requestCounters) {
                for (RequestCounter counter : ORDERING.sortedCopy(this.counters.values())) {
                    totalRequests += counter.getTotalRequests();
                    totalFailed += counter.getFailed();
                    sb.append("\n  ").append(counter);
                }
            }
            formatter.format("\n%-36s %9s %9s", "  Total", totalRequests, totalFailed);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String counterToString(T counterKey) {
        RequestCounter counter;
        RequestCounters requestCounters = this;
        synchronized (requestCounters) {
            counter = this.counters.get(counterKey);
        }
        if (counter == null) {
            throw new NoSuchElementException("counter  " + counterKey + " is not defined in " + this.name + " counters");
        }
        return counter.toString();
    }

    public RequestCounter getCounter(T key) {
        return this.getCounterImpl(key);
    }

    private synchronized RequestCounterImpl getCounterImpl(T key) {
        RequestCounterImpl counter = this.counters.get(key);
        if (counter == null) {
            if (!this.autoCreate) {
                throw new NoSuchElementException("counter with name " + key + " is not defined in " + this.name + " counters");
            }
            this.addCounter(key);
            counter = this.counters.get(key);
        }
        return counter;
    }

    public int getCounterRequests(T counterKey) {
        return this.getCounter(counterKey).getTotalRequests();
    }

    public int getCounterFailed(T counterKey) {
        return this.getCounter(counterKey).getFailed();
    }

    public int getCounterSuccessful(T counterKey) {
        return this.getCounter(counterKey).getSuccessful();
    }

    public void incrementRequests(T counterKey) {
        this.getCounterImpl(counterKey).incrementRequests();
    }

    public void incrementFailed(T counterKey) {
        this.getCounterImpl(counterKey).incrementFailed();
    }

    public void incrementRequests(T counterKey, int increment) {
        this.getCounterImpl(counterKey).incrementRequests(increment);
    }

    public void incrementFailed(T counterKey, int increment) {
        this.getCounterImpl(counterKey).incrementFailed(increment);
    }

    public synchronized int getTotalRequests() {
        int totalRequests = 0;
        for (RequestCounterImpl counter : this.counters.values()) {
            totalRequests += counter.getTotalRequests();
        }
        return totalRequests;
    }

    public synchronized int getTotalFailed() {
        int totalFailed = 0;
        for (RequestCounterImpl counter : this.counters.values()) {
            totalFailed += counter.getFailed();
        }
        return totalFailed;
    }

    public synchronized int getTotalSuccessful() {
        int totalFailed = 0;
        for (RequestCounterImpl counter : this.counters.values()) {
            totalFailed += counter.getSuccessful();
        }
        return totalFailed;
    }

    public synchronized void reset() {
        for (RequestCounterImpl counter : this.counters.values()) {
            counter.reset();
        }
    }

    public synchronized void shutdown() {
        for (RequestCounterImpl counter : this.counters.values()) {
            counter.shutdown();
        }
    }

    public Set<T> keySet() {
        return this.counters.keySet();
    }

    public RequestCounter getTotalRequestCounter() {
        return new RequestCounter(){

            @Override
            public int getFailed() {
                return RequestCounters.this.getTotalFailed();
            }

            @Override
            public String getName() {
                return RequestCounters.this.name + "Totals";
            }

            @Override
            public int getTotalRequests() {
                return RequestCounters.this.getTotalRequests();
            }

            @Override
            public void reset() {
                RequestCounters.this.reset();
            }

            @Override
            public void shutdown() {
                RequestCounters.this.shutdown();
            }

            @Override
            public int getSuccessful() {
                return RequestCounters.this.getTotalSuccessful();
            }
        };
    }
}

