/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.commons.stats;

import java.lang.management.ManagementFactory;
import java.util.Formatter;
import java.util.concurrent.TimeUnit;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.dcache.commons.stats.RequestExecutionTimeGaugeMXBean;
import org.dcache.util.TimeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestExecutionTimeGaugeImpl
implements RequestExecutionTimeGaugeMXBean {
    private static final Logger LOG = LoggerFactory.getLogger(RequestExecutionTimeGaugeImpl.class);
    private final String name;
    private final Statistics statistics = new Statistics();
    private long lastExecutionTime = 0L;
    private long startTime;

    public RequestExecutionTimeGaugeImpl(String name, String family) {
        this.name = name;
        String mxName = String.format("%s:type=RequestExecutionTimeGauge,family=%s,name=%s", this.getClass().getPackage().getName(), family, this.name);
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        try {
            ObjectName mxBeanName = new ObjectName(mxName);
            if (!server.isRegistered(mxBeanName)) {
                server.registerMBean(this, mxBeanName);
            }
        }
        catch (MalformedObjectNameException ex) {
            LOG.warn("Failed to create a MXBean with name: {} : {}", (Object)mxName, (Object)ex.toString());
        }
        catch (InstanceAlreadyExistsException | MBeanRegistrationException ex) {
            LOG.warn("Failed to register a MXBean: {}", (Object)ex.toString());
        }
        catch (NotCompliantMBeanException ex) {
            LOG.warn("Failed to create a MXBean: {}", (Object)ex.toString());
        }
        this.startTime = System.currentTimeMillis();
    }

    @Override
    public synchronized void update(long nextExecTime) {
        if (nextExecTime < 0L) {
            LOG.info("possible backwards time shift detected; discarding invalid data ({})", (Object)nextExecTime);
            return;
        }
        this.statistics.update(nextExecTime);
        this.lastExecutionTime = nextExecTime;
    }

    @Override
    public synchronized double getAverageExecutionTime() {
        return this.statistics.getMean();
    }

    @Override
    public synchronized double resetAndGetAverageExecutionTime() {
        double avg = this.getAverageExecutionTime();
        this.reset();
        return avg;
    }

    public synchronized String toString() {
        String aName = this.name.length() > 34 ? this.name.substring(0, 34) : this.name;
        long updatePeriod = System.currentTimeMillis() - this.startTime;
        StringBuilder sb = new StringBuilder();
        try (Formatter formatter = new Formatter(sb);){
            formatter.format("%-34s %,12.2f\u00b1%,10.2f %,12d %,12d %,12.2f %,12d %12s", aName, this.statistics.getMean(), this.statistics.getStandardError(), this.getMinExecutionTime(), this.getMaxExecutionTime(), this.statistics.getSampleStandardDeviation(), this.statistics.getSampleSize(), TimeUtils.duration(updatePeriod, TimeUnit.MILLISECONDS, TimeUtils.TimeUnitFormat.SHORT));
        }
        return sb.toString();
    }

    @Override
    public synchronized long getMinExecutionTime() {
        return Math.round(this.statistics.getMin());
    }

    @Override
    public synchronized long getMaxExecutionTime() {
        return Math.round(this.statistics.getMax());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public synchronized double getStandardDeviation() {
        return this.statistics.getSampleStandardDeviation();
    }

    @Override
    public synchronized double getStandardError() {
        return this.statistics.getStandardError();
    }

    @Override
    public synchronized long getUpdateNum() {
        return this.statistics.getSampleSize();
    }

    @Override
    public synchronized long getLastExecutionTime() {
        return this.lastExecutionTime;
    }

    @Override
    public synchronized long getStartTime() {
        return this.startTime;
    }

    @Override
    public synchronized void reset() {
        this.startTime = System.currentTimeMillis();
        this.lastExecutionTime = 0L;
        this.statistics.reset();
    }

    private static class Statistics {
        private double mean;
        private double m2;
        private double min = Double.NaN;
        private double max = Double.NaN;
        private long n;

        private Statistics() {
        }

        public void reset() {
            this.m2 = 0.0;
            this.mean = 0.0;
            this.max = Double.NaN;
            this.min = Double.NaN;
            this.n = 0L;
        }

        public void update(double x) {
            this.min = this.n == 0L ? x : Math.min(x, this.min);
            this.max = this.n == 0L ? x : Math.max(x, this.max);
            ++this.n;
            double nextMean = this.mean + (x - this.mean) / (double)this.n;
            double nextM2 = this.m2 + (x - this.mean) * (x - nextMean);
            this.mean = nextMean;
            this.m2 = nextM2;
        }

        public double getMean() {
            return this.n > 0L ? this.mean : Double.NaN;
        }

        public double getSampleVariance() {
            return this.n > 1L ? this.m2 / (double)(this.n - 1L) : Double.NaN;
        }

        public double getPopulationVariance() {
            return this.n > 0L ? this.m2 / (double)this.n : Double.NaN;
        }

        public double getSampleStandardDeviation() {
            return Math.sqrt(this.getSampleVariance());
        }

        public double getPopulationStandardDeviation() {
            return Math.sqrt(this.getPopulationVariance());
        }

        public double getStandardError() {
            return this.getSampleStandardDeviation() / Math.sqrt(this.n);
        }

        public long getSampleSize() {
            return this.n;
        }

        public double getMin() {
            return this.min;
        }

        public double getMax() {
            return this.max;
        }
    }
}

