/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.commons.stats.rrd;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.security.AccessControlException;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import org.dcache.commons.stats.RequestExecutionTimeGauge;
import org.dcache.commons.stats.RequestExecutionTimeGauges;
import org.dcache.commons.stats.rrd.RRDRequestExecutionTimeGauge;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RrdRequestExecutionTimeGauges<T> {
    private static final Logger logger = LoggerFactory.getLogger(RrdRequestExecutionTimeGauges.class);
    private final Map<T, RRDRequestExecutionTimeGauge> rrdgauges = new HashMap<T, RRDRequestExecutionTimeGauge>();
    private final RequestExecutionTimeGauges<T> gauges;
    private static final Timer rrdTimer = new Timer("RrdRequestGauges", true);
    private final File rrdDir;
    private TimerTask updateRrd;
    private TimerTask updateRrdGraphs;
    private long updatePeriodSecs = 60L;
    private long graphPeriodSecs = 300L;

    public RrdRequestExecutionTimeGauges(RequestExecutionTimeGauges<T> requestGauges, File rrdDir) throws IOException {
        this(requestGauges, rrdDir, 60L, 300L);
    }

    public RrdRequestExecutionTimeGauges(RequestExecutionTimeGauges<T> requestGauges, File rrdDir, long updatePeriodSecs, long graphPeriodSecs) throws IOException {
        logger.debug("RrdRequestGauges(" + requestGauges + ", " + rrdDir);
        this.gauges = requestGauges;
        this.rrdDir = rrdDir;
        if (!rrdDir.exists()) {
            rrdDir.mkdir();
        }
        if (!(rrdDir.exists() && rrdDir.canRead() && rrdDir.canWrite() && rrdDir.canExecute())) {
            throw new AccessControlException("directory " + rrdDir + " does not exists or is not accessable");
        }
        this.updatePeriodSecs = updatePeriodSecs;
        this.graphPeriodSecs = graphPeriodSecs;
        this.updateIndex();
    }

    public synchronized void startRrdUpdates() {
        if (this.updateRrd != null) {
            throw new IllegalStateException("RRD Updates are started");
        }
        this.updateRrd = new TimerTask(){

            @Override
            public void run() {
                logger.debug("RrdRequestGauges updateRrd running updateRrds()");
                try {
                    RrdRequestExecutionTimeGauges.this.updateRrds();
                    logger.debug("RrdRequestGauges updateRrd updateRrds() is done");
                }
                catch (IOException ioe) {
                    logger.error("updateRrds io exception : ", (Throwable)ioe);
                }
            }
        };
        rrdTimer.schedule(this.updateRrd, this.updatePeriodSecs * 1000L, this.updatePeriodSecs * 1000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateRrds() throws IOException {
        boolean gaugesAdded = false;
        logger.debug("updateRrds() for " + this.gauges);
        RequestExecutionTimeGauges<T> requestExecutionTimeGauges = this.gauges;
        synchronized (requestExecutionTimeGauges) {
            for (T key : this.gauges.keySet()) {
                logger.debug("updatePrds(): key is " + key);
                if (this.rrdgauges.containsKey(key)) continue;
                RequestExecutionTimeGauge requestGauges = this.gauges.getGauge(key);
                logger.debug("updatePrds(): creating RRDRequestExecutionTimeGauge for " + requestGauges);
                RRDRequestExecutionTimeGauge rrdRequestGauges = new RRDRequestExecutionTimeGauge(this.rrdDir, requestGauges, this.updatePeriodSecs);
                this.rrdgauges.put(key, rrdRequestGauges);
                gaugesAdded = true;
            }
        }
        for (RRDRequestExecutionTimeGauge gauge : this.rrdgauges.values()) {
            logger.debug("updateRrds(): calling gauge.update()");
            gauge.update();
        }
        logger.debug("updateRrds(): calling totalRequestCounter.update()");
        if (gaugesAdded) {
            this.updateIndex();
        }
    }

    public void plotGraphs() throws IOException {
        for (RRDRequestExecutionTimeGauge gauge : this.rrdgauges.values()) {
            gauge.graph();
        }
    }

    public synchronized void startRrdGraphPlots() {
        if (this.updateRrdGraphs != null) {
            throw new IllegalStateException("RRD Graph Updates are started");
        }
        this.updateRrdGraphs = new TimerTask(){

            @Override
            public void run() {
                try {
                    logger.debug("RrdRequestGauges updateRrd running plotGraphs()");
                    RrdRequestExecutionTimeGauges.this.plotGraphs();
                }
                catch (IOException ioe) {
                    logger.error("plotGraphs io exception : ", (Throwable)ioe);
                }
            }
        };
        rrdTimer.schedule(this.updateRrdGraphs, this.updatePeriodSecs * 1000L, this.graphPeriodSecs * 1000L);
    }

    public synchronized void stopRrdUpdates() {
        if (this.updateRrd != null) {
            this.updateRrd.cancel();
            this.updateRrd = null;
        }
    }

    public synchronized void stopRrdGraphPlots() {
        if (this.updateRrdGraphs != null) {
            this.updateRrdGraphs.cancel();
            this.updateRrdGraphs = null;
        }
    }

    private void updateIndex() throws IOException {
        File index = new File(this.rrdDir, "index.html");
        String indexHtml = this.getIndexHtml();
        try (FileWriter fw = new FileWriter(index);){
            fw.write(indexHtml);
        }
    }

    private String getIndexHtml() {
        StringBuilder sb = new StringBuilder();
        sb.append("<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">\n");
        sb.append("<html>\n");
        sb.append("<head>\n");
        sb.append("  <meta content=\"text/html; charset=ISO-8859-1\"\n");
        sb.append(" http-equiv=\"content-type\">\n");
        sb.append("  <title>Request Execution Time Graphs Index for ");
        sb.append(this.gauges.getName());
        sb.append(" </title>\n");
        sb.append("</head>\n");
        sb.append("<body>\n");
        sb.append("  <h1>Request Execution Time Graphs Index for ");
        sb.append(this.gauges.getName());
        sb.append(" </h1>\n");
        sb.append("  <table> \n");
        sb.append("  <tr> <td> \n");
        for (RRDRequestExecutionTimeGauge gauge : this.rrdgauges.values()) {
            sb.append("  <tr> <td> \n");
            String nextHtml = gauge.getRrdGraphicsHtmlFileName();
            sb.append("<a href=\"");
            sb.append(nextHtml);
            sb.append("\">");
            sb.append(nextHtml);
            sb.append("</a>\n");
            sb.append("  </td> </tr> \n");
        }
        sb.append("</body>");
        sb.append("</html>");
        return sb.toString();
    }

    public static void main(String[] args) throws Exception {
        String dirname = args[0];
        RequestExecutionTimeGauges<String> retg = new RequestExecutionTimeGauges<String>(dirname);
        Random r = new Random();
        retg.update("gauge1", r.nextInt(100));
        retg.update("gauge2", r.nextInt(100));
        File dir = new File(dirname);
        RrdRequestExecutionTimeGauges rrdrcs = new RrdRequestExecutionTimeGauges(retg, dir, 10L, 20L);
        rrdrcs.startRrdUpdates();
        rrdrcs.startRrdGraphPlots();
        while (true) {
            Thread.sleep(10000L);
            retg.update("gauge1", r.nextInt(300));
            retg.update("gauge2", r.nextInt(300));
            System.out.println("updated gauges:\n" + retg);
        }
    }
}

