/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.util;

import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheStats;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import eu.emi.security.authn.x509.ProxySupport;
import eu.emi.security.authn.x509.RevocationParameters;
import eu.emi.security.authn.x509.StoreUpdateListener;
import eu.emi.security.authn.x509.ValidationError;
import eu.emi.security.authn.x509.ValidationErrorCode;
import eu.emi.security.authn.x509.ValidationErrorListener;
import eu.emi.security.authn.x509.ValidationResult;
import eu.emi.security.authn.x509.X509CertChainValidatorExt;
import java.security.cert.CertPath;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;

public class CachingCertificateValidator
implements X509CertChainValidatorExt {
    protected final Cache<String, ValidationResult> cache;
    protected final X509CertChainValidatorExt validator;

    public CachingCertificateValidator(X509CertChainValidatorExt val, long maxCacheEntryLifetime) {
        this.cache = CacheBuilder.newBuilder().expireAfterWrite(maxCacheEntryLifetime, TimeUnit.MILLISECONDS).build();
        this.validator = val;
    }

    public ValidationResult validate(final X509Certificate[] certChain) {
        Preconditions.checkNotNull((Object)certChain, (Object)"Cannot validate a null cert chain.");
        Preconditions.checkArgument((certChain.length > 0 ? 1 : 0) != 0, (Object)"Cannot validate a cert chain of length 0.");
        int pos = 0;
        try {
            for (X509Certificate cert : certChain) {
                cert.checkValidity();
                ++pos;
            }
            pos = 0;
            Hasher hasher = Hashing.sha256().newHasher();
            for (X509Certificate cert : certChain) {
                hasher.putBytes(cert.getEncoded());
                ++pos;
            }
            String certFingerprint = hasher.hash().toString();
            return (ValidationResult)this.cache.get((Object)certFingerprint, (Callable)new Callable<ValidationResult>(){

                @Override
                public ValidationResult call() throws Exception {
                    return CachingCertificateValidator.this.validator.validate(certChain);
                }
            });
        }
        catch (CertificateEncodingException e) {
            return new ValidationResult(false, Collections.singletonList(new ValidationError(certChain, pos, ValidationErrorCode.inputError, new Object[]{e.getMessage()})));
        }
        catch (ExecutionException e) {
            return new ValidationResult(false, Collections.singletonList(new ValidationError(certChain, pos, ValidationErrorCode.inputError, new Object[]{e.getMessage()})));
        }
        catch (CertificateExpiredException e) {
            return new ValidationResult(false, Collections.singletonList(new ValidationError(certChain, pos, ValidationErrorCode.certificateExpired, new Object[]{e.getMessage()})));
        }
        catch (CertificateNotYetValidException e) {
            return new ValidationResult(false, Collections.singletonList(new ValidationError(certChain, pos, ValidationErrorCode.certificateNotYetValid, new Object[]{e.getMessage()})));
        }
    }

    public CacheStats stats() {
        return this.cache.stats();
    }

    public void dispose() {
        this.validator.dispose();
    }

    public ProxySupport getProxySupport() {
        return this.validator.getProxySupport();
    }

    public ValidationResult validate(CertPath certPath) {
        return this.validator.validate(certPath);
    }

    public RevocationParameters getRevocationCheckingMode() {
        return this.validator.getRevocationCheckingMode();
    }

    public X509Certificate[] getTrustedIssuers() {
        return this.validator.getTrustedIssuers();
    }

    public void addValidationListener(ValidationErrorListener listener) {
        this.validator.addValidationListener(listener);
    }

    public void removeValidationListener(ValidationErrorListener listener) {
        this.validator.removeValidationListener(listener);
    }

    public void addUpdateListener(StoreUpdateListener listener) {
        this.validator.addUpdateListener(listener);
    }

    public void removeUpdateListener(StoreUpdateListener listener) {
        this.validator.removeUpdateListener(listener);
    }
}

