/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.util;

import com.google.common.base.CharMatcher;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import java.io.Serializable;
import java.util.Set;
import org.dcache.util.ChecksumType;

public class Checksum
implements Serializable {
    private static final long serialVersionUID = 7338775749513974986L;
    private static final String HEX_DIGITS = "0123456789abcdef";
    private static final CharMatcher HEXADECIMAL = CharMatcher.anyOf((CharSequence)"0123456789abcdef");
    private static final char DELIMITER = ':';
    private final ChecksumType type;
    private final String value;

    public Checksum(ChecksumType type, byte[] value) {
        this(type, Checksum.bytesToHexString(value));
    }

    public Checksum(ChecksumType type, String value) {
        Preconditions.checkNotNull((Object)((Object)type), (Object)"type may not be null");
        Preconditions.checkNotNull((Object)value, (Object)"value may not be null");
        this.type = type;
        this.value = this.normalise(value);
    }

    private String normalise(String original) {
        String normalised = original.trim().toLowerCase();
        if (this.type == ChecksumType.ADLER32) {
            normalised = Strings.padStart((String)normalised, (int)this.type.getNibbles(), (char)'0');
        }
        if (!HEXADECIMAL.matchesAllOf((CharSequence)normalised)) {
            throw new IllegalArgumentException("checksum value \"" + original + "\" contains non-hexadecimal digits");
        }
        if (normalised.length() != this.type.getNibbles()) {
            throw new IllegalArgumentException(this.type.getName() + " requires " + this.type.getNibbles() + " hexadecimal digits but \"" + original + "\" has " + normalised.length());
        }
        return normalised;
    }

    public ChecksumType getType() {
        return this.type;
    }

    public String getValue() {
        return this.value;
    }

    public byte[] getBytes() {
        return Checksum.stringToBytes(this.value);
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!other.getClass().equals(Checksum.class)) {
            return false;
        }
        Checksum that = (Checksum)other;
        return this.type == that.type && this.value.equals(that.value);
    }

    public int hashCode() {
        return this.value.hashCode() ^ this.type.hashCode();
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean useStringKey) {
        return (useStringKey ? this.type.getName() : String.valueOf(this.type.getType())) + ":" + this.value;
    }

    public static String bytesToHexString(byte[] bytes) {
        Preconditions.checkNotNull((Object)bytes, (Object)"byte array may not be null");
        StringBuilder sb = new StringBuilder();
        for (byte aByte : bytes) {
            sb.append(HEX_DIGITS.charAt(aByte >> 4 & 0xF));
            sb.append(HEX_DIGITS.charAt(aByte & 0xF));
        }
        return sb.toString();
    }

    private static byte[] stringToBytes(String str) {
        if (str.length() % 2 != 0) {
            str = "0" + str;
        }
        byte[] r = new byte[str.length() / 2];
        int l = str.length();
        for (int i = 0; i < l; i += 2) {
            r[i / 2] = (byte)Integer.parseInt(str.substring(i, i + 2), 16);
        }
        return r;
    }

    public static Checksum parseChecksum(String digest) {
        Preconditions.checkNotNull((Object)digest, (Object)"value may not be null");
        int del = digest.indexOf(58);
        if (del < 1) {
            throw new IllegalArgumentException("Not a dCache checksum: " + digest);
        }
        String type = digest.substring(0, del);
        String checksum = digest.substring(del + 1);
        return new Checksum(ChecksumType.getChecksumType(type), checksum);
    }

    public static Optional<Checksum> forType(Set<Checksum> checksums, final ChecksumType type) {
        return Iterables.tryFind(checksums, (Predicate)new Predicate<Checksum>(){

            public boolean apply(Checksum t) {
                return t.getType() == type;
            }
        });
    }
}

