/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.util;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigInteger;
import org.dcache.util.Args;
import org.dcache.util.Option;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OptionParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(OptionParser.class);
    private final Args args;

    public OptionParser(Args args) {
        this.args = args;
    }

    public static <T> T inject(Args args, T object) {
        return new OptionParser(args).inject(object);
    }

    public static <T> T injectDefaults(T object) {
        return OptionParser.inject(new Args(new String[0]), object);
    }

    public static <T> T toType(Object object, Class<T> type) {
        if (object == null) {
            if (type == Boolean.TYPE) {
                return Boolean.class.cast(false);
            }
            if (type == Byte.TYPE) {
                return Byte.class.cast(0);
            }
            if (type == Character.TYPE) {
                return Character.class.cast(0);
            }
            if (type == Double.TYPE) {
                return Double.class.cast(0.0);
            }
            if (type == Float.TYPE) {
                return Float.class.cast(0.0);
            }
            if (type == Integer.TYPE) {
                return Integer.class.cast(0);
            }
            if (type == Long.TYPE) {
                return Long.class.cast(0);
            }
            if (type == Short.TYPE) {
                return Short.class.cast(0);
            }
            return null;
        }
        String so = object.toString();
        if (type == BigInteger.class) {
            return type.cast(new BigInteger(so));
        }
        if (type == Boolean.class || type == Boolean.TYPE) {
            Boolean r = "1".equals(so) || "true".equalsIgnoreCase(so) || "yes".equalsIgnoreCase(so) || "on".equalsIgnoreCase(so) || "enabled".equalsIgnoreCase(so) ? Boolean.TRUE : ("0".equals(object) || "false".equalsIgnoreCase(so) || "no".equalsIgnoreCase(so) || "off".equalsIgnoreCase(so) || "disabled".equalsIgnoreCase(so) ? Boolean.FALSE : Boolean.valueOf(so));
            if (type == Boolean.TYPE) {
                return Boolean.class.cast(r);
            }
            return type.cast(r);
        }
        if (type == Byte.class || type == Byte.TYPE) {
            Byte i = Byte.valueOf(so);
            if (type == Byte.TYPE) {
                return Byte.class.cast(i);
            }
            return type.cast(i);
        }
        if (type == Character.class || type == Character.TYPE) {
            Character i = Character.valueOf(so.charAt(0));
            if (type == Character.TYPE) {
                return Character.class.cast(i);
            }
            return type.cast(i);
        }
        if (type == Double.class || type == Double.TYPE) {
            Double i = Double.valueOf(so);
            if (type == Double.TYPE) {
                return Double.class.cast(i);
            }
            return type.cast(i);
        }
        if (type == Float.class || type == Float.TYPE) {
            Float i = Float.valueOf(so);
            if (type == Float.TYPE) {
                return Float.class.cast(i);
            }
            return type.cast(i);
        }
        if (type == Integer.class || type == Integer.TYPE) {
            Integer i = Integer.valueOf(so);
            if (type == Integer.TYPE) {
                return Integer.class.cast(i);
            }
            return type.cast(i);
        }
        if (type == Long.class || type == Long.TYPE) {
            Long i = Long.valueOf(so);
            if (type == Long.TYPE) {
                return Long.class.cast(i);
            }
            return type.cast(i);
        }
        if (type == Short.class || type == Short.TYPE) {
            Short i = Short.valueOf(so);
            if (type == Short.TYPE) {
                return Short.class.cast(i);
            }
            return type.cast(i);
        }
        if (Enum.class.isAssignableFrom(type)) {
            return Enum.valueOf(type, so);
        }
        if (Class.class.isAssignableFrom(type)) {
            try {
                return type.cast(Class.forName(so));
            }
            catch (ClassNotFoundException e) {
                return type.cast(object);
            }
        }
        try {
            Method valueOf = type.getMethod("valueOf", object.getClass());
            if (Modifier.isStatic(valueOf.getModifiers()) && type.isAssignableFrom(valueOf.getReturnType())) {
                return type.cast(valueOf.invoke(null, object));
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
        try {
            return type.getConstructor(String.class).newInstance(object);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            return type.cast(object);
        }
    }

    protected String getOption(Option option) {
        String s = this.args.getOpt(option.name());
        if (!(s == null || s.length() <= 0 && option.required())) {
            return s;
        }
        if (option.required()) {
            throw new IllegalArgumentException(option.name() + " is a required argument");
        }
        return option.defaultValue();
    }

    public <T> T inject(T obj) {
        for (Class<?> c = obj.getClass(); c != null; c = c.getSuperclass()) {
            for (Field field : c.getDeclaredFields()) {
                Option option = field.getAnnotation(Option.class);
                try {
                    Object value;
                    if (option == null) continue;
                    field.setAccessible(true);
                    String s = this.getOption(option);
                    if (s != null && s.length() > 0) {
                        try {
                            value = OptionParser.toType(s, field.getType());
                            field.set(obj, value);
                        }
                        catch (NumberFormatException e) {
                            throw new IllegalArgumentException("Invalid value for option " + option.name() + ": " + e.toString(), e);
                        }
                        catch (ClassCastException e) {
                            throw new IllegalArgumentException("Invalid value for option " + option.name() + ": Cannot convert '" + s + "' to " + field.getType() + ".", e);
                        }
                    } else {
                        value = field.get(obj);
                    }
                    if (!option.log()) continue;
                    String description = option.description();
                    String unit = option.unit();
                    if (description.length() == 0) {
                        description = option.name();
                    }
                    if (unit.length() > 0) {
                        LOGGER.info("{} set to {} {}", new Object[]{description, value, unit});
                        continue;
                    }
                    LOGGER.info("{} set to {}", (Object)description, value);
                }
                catch (IllegalAccessException | SecurityException e) {
                    throw new RuntimeException("Bug detected while processing option " + option.name(), e);
                }
            }
        }
        return obj;
    }
}

