/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.util;

import com.google.common.base.CharMatcher;
import java.io.Serializable;
import org.dcache.util.Glob;

public class SqlGlob
implements Serializable {
    private static final long serialVersionUID = -5052804169005574207L;
    private static final CharMatcher WILDCARD = CharMatcher.anyOf((CharSequence)"*?");
    private final String _pattern;

    public SqlGlob(String s) {
        this._pattern = s;
    }

    public boolean isGlob() {
        return SqlGlob.isGlob(this._pattern);
    }

    public String toString() {
        return this._pattern;
    }

    public Glob toGlob() {
        return new Glob(this._pattern);
    }

    public String toSql() {
        return SqlGlob.parseGlobToSql(this._pattern);
    }

    public static String parseGlobToSql(String glob) {
        StringBuilder s = new StringBuilder(glob.length() * 2 + 2);
        int j = 0;
        block4: for (int i = 0; i < glob.length(); ++i) {
            switch (glob.charAt(i)) {
                case '?': {
                    s.append(SqlGlob.quoteSql(glob.substring(j, i)));
                    s.append("_");
                    j = i + 1;
                    continue block4;
                }
                case '*': {
                    s.append(SqlGlob.quoteSql(glob.substring(j, i)));
                    s.append("%");
                    j = i + 1;
                    continue block4;
                }
            }
        }
        s.append(SqlGlob.quoteSql(glob.substring(j)));
        return s.toString();
    }

    private static String quoteSql(String s) {
        return s.replace("\\", "\\\\").replace("_", "\\_").replace("%", "\\%");
    }

    public static boolean isGlob(String s) {
        return WILDCARD.matchesAnyOf((CharSequence)s);
    }
}

