/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.alarms;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.regex.Pattern;
import org.dcache.alarms.Alarm;
import org.dcache.alarms.AlarmDefinitionValidationException;
import org.dcache.util.RegexUtils;

public interface AlarmDefinition
extends Alarm {
    public static final String ALARM_TAG = "alarm";
    public static final String DEPTH_TAG = "depth";
    public static final String GROUP_TAG = "group";
    public static final int GROUP_TAG_LENGTH = "group".length();
    public static final String KEY_WORDS_TAG = "keyWords";
    public static final String MATCH_EXCEPTION_TAG = "matchException";
    public static final String MESSAGE_TAG = "message";
    public static final String REGEX_TAG = "regex";
    public static final String REGEX_FLAGS_TAG = "regexFlags";
    public static final String KEY_WORD_DELIMITER = "[\\s]";
    public static final String TIMESTAMP_TAG = "timestamp";
    public static final String TYPE_TAG = "type";
    public static final String RM = "-";
    public static final String REQUIRED = " is a required attribute.";
    public static final ImmutableList<String> ATTRIBUTES = new ImmutableList.Builder().add((Object)"type").add((Object)"keyWords").add((Object)"regex").add((Object)"regexFlags").add((Object)"matchException").add((Object)"depth").build();
    public static final ImmutableSet<String> KEY_VALUES = new ImmutableSet.Builder().add((Object)"timestamp").add((Object)"type").add((Object)"domain").add((Object)"service").add((Object)"host").add((Object)"message").add((Object)"groupN").build();
    public static final ImmutableList<String> DEFINITIONS = new ImmutableList.Builder().add((Object)"Choose a name to call this type of alarm (required).").add((Object)("Create the unique identifier for this alarm event based on the selected fields (whitespace delimited) " + KEY_VALUES + " (required).")).add((Object)"Java-style regular expression used to match messages  (required).").add((Object)("Java-style flag options for regex; join using '|' (or) " + RegexUtils.FLAG_VALUES + " (optional; default: none).")).add((Object)"Apply the regex to nested exception messages  (boolean, optional; default: false).").add((Object)"Match nested exception messages using regex only to this level (integer, optional; default: undefined).").build();

    public Integer getDepth();

    public String createKey(String var1, long var2, String var4, String var5, String var6);

    public String getKeyWords();

    public Boolean isMatchException();

    public String getRegexFlags();

    public Pattern getRegexPattern();

    public String getRegexString();

    public void setDepth(Integer var1);

    public void setKeyWords(String var1);

    public void setMatchException(Boolean var1);

    public void setRegexString(String var1);

    public void setRegexFlags(String var1);

    public void setType(String var1);

    public void validate() throws AlarmDefinitionValidationException;

    public void validateAndSet(String var1, String var2) throws AlarmDefinitionValidationException;
}

