/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.auth;

import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FQAN
implements Serializable {
    private static final long serialVersionUID = -2212735007788920585L;
    private static final String NULL_CAPABILITY = "/Capability=NULL";
    private static final String NULL_ROLE = "/Role=NULL";
    private static final String RE_VALID_LABEL = "[a-z]([a-z0-9-]*[a-z0-9])?";
    private static final String RE_RFC_1035_VALUE = "[a-z]([a-z0-9-]*[a-z0-9])?(\\.[a-z]([a-z0-9-]*[a-z0-9])?)*";
    private static final String RE_VALID_VO_VALUE = "/[a-z]([a-z0-9-]*[a-z0-9])?(\\.[a-z]([a-z0-9-]*[a-z0-9])?)*";
    private static final String RE_VALID_GROUP_VALUE = "(/[\\w-]+)*";
    private static final String RE_VALID_ROLE_VALUE = "[\\w-]+";
    private static final String RE_VALID_CAPABILITY_VALUE = "[\\w-]+";
    private static final String RE_VALID_FQAN = "^/[a-z]([a-z0-9-]*[a-z0-9])?(\\.[a-z]([a-z0-9-]*[a-z0-9])?)*((/[\\w-]+)*)?(/Role=[\\w-]+)?(/Capability=[\\w-]+)?$";
    private static final Pattern VALID_FQAN = Pattern.compile("^/[a-z]([a-z0-9-]*[a-z0-9])?(\\.[a-z]([a-z0-9-]*[a-z0-9])?)*((/[\\w-]+)*)?(/Role=[\\w-]+)?(/Capability=[\\w-]+)?$");
    private static Pattern p1 = Pattern.compile("(.*)/Role=(.*)/Capability=(.*)");
    private static Pattern p2 = Pattern.compile("(.*)/Role=(.*)(.*)");
    private static Pattern p3 = Pattern.compile("(.*)()/Capability=(.*)");
    private static Pattern p4 = Pattern.compile("(.*)(.*)(.*)");
    private transient Matcher m;
    private final String fqan;

    public static boolean isValid(String fqan) {
        if (fqan == null) {
            return false;
        }
        Matcher fqanMatcher = VALID_FQAN.matcher(fqan);
        return fqanMatcher.matches();
    }

    public FQAN(String fqan) {
        if (fqan == null) {
            throw new IllegalArgumentException("fqan is null");
        }
        fqan = FQAN.filterOutNullCapability(fqan);
        this.fqan = fqan = FQAN.filterOutNullRole(fqan);
    }

    private static String filterOutNullCapability(String originalFqan) {
        String filteredFqan;
        if (originalFqan.endsWith(NULL_CAPABILITY)) {
            int newLength = originalFqan.length() - NULL_CAPABILITY.length();
            filteredFqan = originalFqan.substring(0, newLength);
        } else {
            filteredFqan = originalFqan;
        }
        return filteredFqan;
    }

    private static String filterOutNullRole(String originalFqan) {
        int index = originalFqan.indexOf(NULL_ROLE);
        if (index == -1) {
            return originalFqan;
        }
        StringBuilder filteredFqan = new StringBuilder();
        filteredFqan.append(originalFqan.substring(0, index));
        filteredFqan.append(originalFqan.substring(index + NULL_ROLE.length()));
        return filteredFqan.toString();
    }

    public String toString() {
        return this.fqan;
    }

    private Matcher getMatcher() {
        if (this.m != null) {
            return this.m;
        }
        this.m = p1.matcher(this.fqan);
        if (!this.m.matches()) {
            this.m = p2.matcher(this.fqan);
            if (!this.m.matches()) {
                this.m = p3.matcher(this.fqan);
                if (!this.m.matches()) {
                    this.m = p4.matcher(this.fqan);
                    this.m.matches();
                }
            }
        }
        return this.m;
    }

    public String getGroup() {
        return this.getMatcher().group(1);
    }

    public String getRole() {
        return this.getMatcher().group(2);
    }

    public boolean hasRole() {
        String role = this.getRole();
        return !role.isEmpty();
    }

    public String getCapability() {
        return this.getMatcher().group(3);
    }

    public boolean hasCapability() {
        String capability = this.getCapability();
        return !capability.isEmpty();
    }

    public FQAN getParent() {
        int i = this.fqan.lastIndexOf(47);
        return i > 1 ? new FQAN(this.fqan.substring(0, i)) : null;
    }

    public int hashCode() {
        return this.fqan.hashCode();
    }

    public boolean equals(Object testFQAN) {
        if (testFQAN == this) {
            return true;
        }
        if (!(testFQAN instanceof FQAN)) {
            return false;
        }
        FQAN otherFQAN = (FQAN)testFQAN;
        return this.fqan.equals(otherFQAN.fqan);
    }

    public static void main(String[] args) {
        FQAN fqan = new FQAN(args[0]);
        System.out.println("FQAN     = " + fqan);
        System.out.println("Group    = " + fqan.getGroup());
        System.out.println("Role     = " + fqan.getRole());
        System.out.println("Capacity = " + fqan.getGroup());
    }
}

