/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.auth;

import java.io.Serializable;
import java.security.Principal;

public class UidPrincipal
implements Principal,
Serializable {
    private static final long serialVersionUID = 1489893133915358418L;
    private long _uid;

    public UidPrincipal(long uid) {
        if (uid < 0L) {
            throw new IllegalArgumentException("UID must be non-negative");
        }
        this._uid = uid;
    }

    public UidPrincipal(String uid) {
        this(Long.parseLong(uid));
    }

    public long getUid() {
        return this._uid;
    }

    @Override
    public String getName() {
        return String.valueOf(this._uid);
    }

    @Override
    public int hashCode() {
        return (int)this._uid;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof UidPrincipal)) {
            return false;
        }
        UidPrincipal otherUid = (UidPrincipal)other;
        return otherUid.getUid() == this.getUid();
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getName() + "]";
    }
}

