/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.auth.attributes;

import com.google.common.base.Joiner;
import diskCacheV111.util.FsPath;
import java.util.EnumSet;
import org.dcache.auth.attributes.Activity;
import org.dcache.auth.attributes.Restriction;

public class DenyActivityRestriction
implements Restriction {
    private static final long serialVersionUID = 1L;
    private final EnumSet<Activity> denied;

    public static DenyActivityRestriction restrictAllActivity() {
        return new DenyActivityRestriction(EnumSet.allOf(Activity.class));
    }

    public static DenyActivityRestriction restrictNoActivity() {
        return new DenyActivityRestriction(EnumSet.noneOf(Activity.class));
    }

    public DenyActivityRestriction(Activity ... denied) {
        this.denied = denied.length > 0 ? EnumSet.of(denied[0], denied) : EnumSet.noneOf(Activity.class);
    }

    private DenyActivityRestriction(EnumSet<Activity> denied) {
        this.denied = denied;
    }

    @Override
    public boolean isRestricted(Activity activity, FsPath path) {
        return this.denied.contains((Object)activity);
    }

    @Override
    public boolean isRestricted(Activity activity, FsPath directory, String name) {
        return this.denied.contains((Object)activity);
    }

    public int hashCode() {
        return this.denied.hashCode();
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof DenyActivityRestriction && this.denied.equals(((DenyActivityRestriction)other).denied);
    }

    @Override
    public boolean isSubsumedBy(Restriction other) {
        if (!(other instanceof DenyActivityRestriction)) {
            return false;
        }
        EnumSet<Activity> otherDenied = ((DenyActivityRestriction)other).denied;
        return otherDenied.containsAll(this.denied);
    }

    @Override
    public String toString() {
        if (this.denied.isEmpty()) {
            return "Unrestricted";
        }
        if (this.denied.size() == Activity.values().length) {
            return "FullyRestricted";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Restrict[");
        Joiner.on((char)',').appendTo(sb, this.denied);
        sb.append(']');
        return sb.toString();
    }
}

