/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.commons.stats;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.Uninterruptibles;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.dcache.commons.stats.RequestCounters;
import org.dcache.commons.stats.RequestExecutionTimeGauges;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonitoringProxy<T>
implements InvocationHandler {
    private static final Logger logger = LoggerFactory.getLogger(MonitoringProxy.class);
    private final T monitoredObject;
    private final RequestCounters<Method> counter;
    private final RequestExecutionTimeGauges<Method> gauge;

    private MonitoringProxy(T monitoredObject, RequestCounters<Method> counter, RequestExecutionTimeGauges<Method> gauge) {
        this.monitoredObject = Preconditions.checkNotNull(monitoredObject);
        this.counter = (RequestCounters)Preconditions.checkNotNull(counter);
        this.gauge = (RequestExecutionTimeGauges)Preconditions.checkNotNull(gauge);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        this.counter.incrementRequests(method);
        long startTimeStamp = System.currentTimeMillis();
        Object result = null;
        try {
            result = method.invoke(this.monitoredObject, args);
        }
        catch (InvocationTargetException e) {
            try {
                this.counter.incrementFailed(method);
                throw e.getTargetException();
                catch (Error | RuntimeException e2) {
                    this.counter.incrementFailed(method);
                    throw e2;
                }
            }
            catch (Throwable throwable) {
                if (result instanceof ListenableFuture) {
                    ListenableFuture future = (ListenableFuture)result;
                    future.addListener(new Runnable(future, method, startTimeStamp){
                        final /* synthetic */ ListenableFuture val$future;
                        final /* synthetic */ Method val$method;
                        final /* synthetic */ long val$startTimeStamp;
                        {
                            this.val$future = listenableFuture;
                            this.val$method = method;
                            this.val$startTimeStamp = l;
                        }

                        @Override
                        public void run() {
                            try {
                                Uninterruptibles.getUninterruptibly((Future)this.val$future);
                            }
                            catch (Error | RuntimeException | ExecutionException e) {
                                MonitoringProxy.this.counter.incrementFailed(this.val$method);
                            }
                            MonitoringProxy.this.updateTime(this.val$method, this.val$startTimeStamp);
                        }
                    }, MoreExecutors.directExecutor());
                    throw throwable;
                }
                this.updateTime(method, startTimeStamp);
                throw throwable;
            }
        }
        if (result instanceof ListenableFuture) {
            ListenableFuture future = (ListenableFuture)result;
            future.addListener(new /* invalid duplicate definition of identical inner class */, MoreExecutors.directExecutor());
            return result;
        }
        this.updateTime(method, startTimeStamp);
        return result;
    }

    private void updateTime(Method method, long startTimeStamp) {
        long execTime = System.currentTimeMillis() - startTimeStamp;
        logger.debug("invocation of {} took {} ms", (Object)method, (Object)execTime);
        this.gauge.update(method, execTime);
    }

    public static <T> T decorateWithMonitoringProxy(Class<?>[] interfaces, T monitoringObject, RequestCounters<Method> counter, RequestExecutionTimeGauges<Method> gauge) {
        MonitoringProxy<T> monitoringHandler = new MonitoringProxy<T>(monitoringObject, counter, gauge);
        return (T)Proxy.newProxyInstance(monitoringObject.getClass().getClassLoader(), interfaces, monitoringHandler);
    }
}

