/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.commons.stats.rrd;

import java.awt.Color;
import java.awt.Paint;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.security.AccessControlException;
import java.util.concurrent.TimeUnit;
import org.dcache.commons.stats.RequestExecutionTimeGauge;
import org.rrd4j.ConsolFun;
import org.rrd4j.DsType;
import org.rrd4j.core.RrdDb;
import org.rrd4j.core.RrdDef;
import org.rrd4j.core.Sample;
import org.rrd4j.core.Util;
import org.rrd4j.graph.RrdGraph;
import org.rrd4j.graph.RrdGraphDef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RRDRequestExecutionTimeGauge {
    private static final long FIVEMIN = TimeUnit.MINUTES.toSeconds(5L);
    private static final long TENMIN = TimeUnit.MINUTES.toSeconds(5L);
    private static final long HOUR = TimeUnit.HOURS.toSeconds(1L);
    private static final long DAY = TimeUnit.DAYS.toSeconds(1L);
    private static final long MONTH = TimeUnit.DAYS.toSeconds(31L);
    private static final long YEAR = TimeUnit.DAYS.toSeconds(365L);
    private static final int DEFAULT_IMAGE_WIDTH = 491;
    private static final int DEFAULT_IMAGE_HEIGHT = 167;
    private static final Logger logger = LoggerFactory.getLogger(RRDRequestExecutionTimeGauge.class);
    private RequestExecutionTimeGauge gauge;
    private String rrdFileName;
    private String rrdFiveminImage;
    private String rrdHourlyImage;
    private String rrdDaylyImage;
    private String rrdMounthlyImage;
    private String rrdYearlyImage;
    private String rrdGraphicsHtmlFileName;
    private int imageWidth = 491;
    private int imageHeight = 167;
    private Long dumpstart;

    public RRDRequestExecutionTimeGauge(File rrdDirectory, RequestExecutionTimeGauge gauge, long updatePeriodSecs) throws IOException {
        this(rrdDirectory, gauge, updatePeriodSecs, 491, 167);
    }

    public RRDRequestExecutionTimeGauge(File rrdDirectory, RequestExecutionTimeGauge gauge, long updatePeriodSecs, int imageWidth, int imageHeight) throws IOException {
        this.imageWidth = imageWidth;
        this.imageHeight = imageHeight;
        if (updatePeriodSecs <= 0L || updatePeriodSecs >= FIVEMIN) {
            throw new IllegalArgumentException("updatePeriodSecs=" + updatePeriodSecs + ", should be greater than 0 and less than " + FIVEMIN + " secs");
        }
        logger.debug("RRDRequestExecutionTimeGauge(" + rrdDirectory + ", " + gauge + "," + updatePeriodSecs + ")");
        if (!(rrdDirectory.exists() && rrdDirectory.isDirectory() && rrdDirectory.canWrite())) {
            throw new AccessControlException("directory " + rrdDirectory + " does not exists or is not accessable");
        }
        File imagesDir = new File(rrdDirectory, "images");
        if (!imagesDir.exists()) {
            imagesDir.mkdir();
        }
        if (!(imagesDir.exists() && imagesDir.isDirectory() && imagesDir.canWrite())) {
            throw new AccessControlException("directory " + imagesDir + " does not exists or is not accessable");
        }
        String rrdImageDir = imagesDir.getCanonicalPath();
        String gaugeName = gauge.getName();
        this.rrdFiveminImage = rrdImageDir + File.separatorChar + gaugeName + ".5min.png";
        this.rrdHourlyImage = rrdImageDir + File.separatorChar + gaugeName + ".hour.png";
        this.rrdDaylyImage = rrdImageDir + File.separatorChar + gaugeName + ".day.png";
        this.rrdMounthlyImage = rrdImageDir + File.separatorChar + gaugeName + ".month.png";
        this.rrdYearlyImage = rrdImageDir + File.separatorChar + gaugeName + ".year.png";
        File f = new File(rrdDirectory, gaugeName + ".rrd4j");
        this.rrdFileName = f.getCanonicalPath();
        if (!f.exists()) {
            RrdDef rrdDef = new RrdDef(this.rrdFileName);
            rrdDef.setStartTime(Util.getTime() - 1L);
            rrdDef.setStep(updatePeriodSecs);
            rrdDef.addDatasource("exectime", DsType.GAUGE, updatePeriodSecs * 2L, 0.0, Double.NaN);
            int samplesPerOur = (int)(HOUR / updatePeriodSecs);
            rrdDef.addArchive(ConsolFun.AVERAGE, 0.5, 1, samplesPerOur);
            rrdDef.addArchive(ConsolFun.MIN, 0.5, 1, samplesPerOur);
            rrdDef.addArchive(ConsolFun.MAX, 0.5, 1, samplesPerOur);
            int samplesPerTenMin = (int)(TENMIN / updatePeriodSecs);
            int tenMinSamplesPer100Hours = (int)(HOUR * 100L / (long)samplesPerTenMin);
            rrdDef.addArchive(ConsolFun.AVERAGE, 0.5, samplesPerTenMin, tenMinSamplesPer100Hours);
            rrdDef.addArchive(ConsolFun.MIN, 0.5, samplesPerTenMin, tenMinSamplesPer100Hours);
            rrdDef.addArchive(ConsolFun.MAX, 0.5, samplesPerTenMin, tenMinSamplesPer100Hours);
            int hourSamplesPerMonth = (int)(MONTH / (long)samplesPerOur);
            rrdDef.addArchive(ConsolFun.AVERAGE, 0.5, samplesPerOur, hourSamplesPerMonth);
            rrdDef.addArchive(ConsolFun.MIN, 0.5, samplesPerOur, hourSamplesPerMonth);
            rrdDef.addArchive(ConsolFun.MAX, 0.5, samplesPerOur, hourSamplesPerMonth);
            int samplesPerDay = (int)(24L * HOUR / updatePeriodSecs);
            int daySamplesPer2Years = (int)(2L * YEAR / (long)samplesPerDay);
            rrdDef.addArchive(ConsolFun.AVERAGE, 0.5, samplesPerDay, daySamplesPer2Years);
            rrdDef.addArchive(ConsolFun.MIN, 0.5, samplesPerDay, daySamplesPer2Years);
            rrdDef.addArchive(ConsolFun.MAX, 0.5, samplesPerDay, daySamplesPer2Years);
            RrdDb rrdDb = new RrdDb(rrdDef);
            rrdDb.close();
        }
        RrdDb rrdDb = new RrdDb(this.rrdFileName);
        rrdDb.close();
        this.gauge = gauge;
        File html = new File(rrdDirectory, gaugeName + ".html");
        if (!html.exists()) {
            String graphicsHtml = RRDRequestExecutionTimeGauge.getGraphicsHtml(gaugeName, imageWidth, imageHeight);
            FileWriter fw = new FileWriter(html);
            fw.write(graphicsHtml);
            fw.close();
        }
        this.rrdGraphicsHtmlFileName = gaugeName + ".html";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() throws IOException {
        logger.debug("RRDRequestExecutionTimeGauge.update() rrdFileName is " + this.rrdFileName);
        RrdDb rrdDb = new RrdDb(this.rrdFileName);
        try {
            Sample sample = rrdDb.createSample();
            long currentTimeSecs = Util.getTime();
            String update = Long.toString(currentTimeSecs) + ':' + (long)this.gauge.resetAndGetAverageExecutionTime() + ':';
            sample.setAndUpdate(update);
            logger.debug("RRDRequestExecutionTimeGauge.update() updated with : " + update);
        }
        finally {
            rrdDb.close();
            logger.debug("RRDRequestExecutionTimeGauge.update() succeeded");
        }
    }

    private void plotGraph(RrdGraphDef graphDef, long beginningtime, long endTime, String filename) throws IOException {
        graphDef.setTimeSpan(beginningtime, endTime);
        graphDef.setFilename(filename);
        RrdGraph graph = new RrdGraph(graphDef);
        BufferedImage bi = new BufferedImage(this.imageWidth, this.imageHeight, 1);
        graph.render(bi.getGraphics());
        logger.debug("RRDRequestExecutionTimeGauge.graph() wrote " + filename);
    }

    public void graph() throws IOException {
        long currentTime = Util.getTime();
        logger.debug("RRDRequestExecutionTimeGauge.graph()");
        RrdDb rrdDb = new RrdDb(this.rrdFileName);
        RrdGraphDef graphDef = new RrdGraphDef();
        graphDef.setVerticalLabel("exectime(ms)");
        graphDef.setUnit("ms");
        graphDef.datasource("exectime_avg", this.rrdFileName, "exectime", ConsolFun.AVERAGE);
        graphDef.line("exectime_avg", (Paint)new Color(187, 0, 0), "exectime_avg", 4.0f);
        graphDef.datasource("exectime_max", this.rrdFileName, "exectime", ConsolFun.MAX);
        graphDef.line("exectime_max", (Paint)new Color(255, 0, 0), "exectime_max", 3.0f);
        graphDef.datasource("exectime_min", this.rrdFileName, "exectime", ConsolFun.MIN);
        graphDef.line("exectime_min", (Paint)new Color(144, 32, 32), "exectime_min", 2.0f);
        this.plotGraph(graphDef, currentTime - FIVEMIN, currentTime, this.rrdFiveminImage);
        this.plotGraph(graphDef, currentTime - HOUR, currentTime, this.rrdHourlyImage);
        this.plotGraph(graphDef, currentTime - DAY, currentTime, this.rrdDaylyImage);
        this.plotGraph(graphDef, currentTime - MONTH, currentTime, this.rrdMounthlyImage);
        this.plotGraph(graphDef, currentTime - YEAR, currentTime, this.rrdYearlyImage);
    }

    public int getImageWidth() {
        return this.imageWidth;
    }

    public void setImageWidth(int imageWidth) {
        this.imageWidth = imageWidth;
    }

    public int getImageHight() {
        return this.imageHeight;
    }

    public void setImageHight(int imageHight) {
        this.imageHeight = imageHight;
    }

    private static String getGraphicsHtml(String gaugeName, int width, int height) {
        StringBuilder style = new StringBuilder("\"width: ");
        style.append(width);
        style.append("px; height: ");
        style.append(height);
        style.append("px;\"");
        StringBuilder sb = new StringBuilder();
        sb.append("<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">\n");
        sb.append("<html>\n");
        sb.append("<head>\n");
        sb.append("  <meta content=\"text/html; charset=ISO-8859-1\"\n");
        sb.append(" http-equiv=\"content-type\">\n");
        sb.append(" <title>Request Execution Time Graphics for ");
        sb.append(gaugeName);
        sb.append("</title>\n");
        sb.append("</head>\n");
        sb.append("<body>\n");
        sb.append("<h1> Request Execution Time Graphics for ");
        sb.append(gaugeName);
        sb.append("</h1> \n");
        sb.append("5 Minutes<br>\n");
        sb.append("<img style=");
        sb.append((CharSequence)style);
        sb.append(" alt=\"5 Minutes\"\n");
        sb.append(" src=\"images/");
        sb.append(gaugeName);
        sb.append(".5min.png\"><br>\n");
        sb.append("Hour<br>\n");
        sb.append("<img style=");
        sb.append((CharSequence)style);
        sb.append(" alt=\"Hour\"\n");
        sb.append(" src=\"images/");
        sb.append(gaugeName);
        sb.append(".hour.png\"><br>\n");
        sb.append("Day<br>\n");
        sb.append("<img style=");
        sb.append((CharSequence)style);
        sb.append(" alt=\"Day\"\n");
        sb.append(" src=\"images/");
        sb.append(gaugeName);
        sb.append(".day.png\"><br>\n");
        sb.append("Month<br>\n");
        sb.append("<img style=");
        sb.append((CharSequence)style);
        sb.append(" alt=\"Month\"\n");
        sb.append(" src=\"images/");
        sb.append(gaugeName);
        sb.append(".month.png\"><br>\n");
        sb.append("Year<br>\n");
        sb.append("<img style=");
        sb.append((CharSequence)style);
        sb.append(" alt=\"Year\"\n");
        sb.append(" src=\"images/");
        sb.append(gaugeName);
        sb.append(".year.png\"><br>\n");
        sb.append("</body>\n");
        sb.append("</html>");
        return sb.toString();
    }

    public String getRrdGraphicsHtmlFileName() {
        return this.rrdGraphicsHtmlFileName;
    }
}

