/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.commons.util;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(SqlHelper.class);

    private SqlHelper() {
    }

    public static void tryToClose(PreparedStatement o) {
        try {
            if (o != null) {
                o.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error("failed to close prepared statement: {}", (Object)e.getMessage());
        }
    }

    public static void tryToClose(Statement o) {
        try {
            if (o != null) {
                o.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error("failed to close result statement: {}", (Object)e.getMessage());
        }
    }

    public static void tryToClose(ResultSet o) {
        try {
            if (o != null) {
                o.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error("failed to close result set: {}", (Object)e.getMessage());
        }
    }

    public static void tryToClose(Connection o) {
        try {
            if (o != null) {
                o.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error("failed to close connection: {}", (Object)e.getMessage());
        }
    }

    public static void tryToRollback(Connection o) {
        try {
            o.rollback();
        }
        catch (SQLException e) {
            LOGGER.error("failed to rollback transaction: {}", (Object)e.getMessage());
        }
    }
}

