/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.util;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;

public class Crypto {
    private static final Splitter CIPHER_FLAG_SPLITTER = Splitter.on((String)",").omitEmptyStrings().trimResults();
    public static final String[] EC_CIPHERS = new String[]{"TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384", "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384", "TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA", "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA", "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256", "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256", "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA", "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA", "TLS_ECDHE_ECDSA_WITH_RC4_128_SHA", "TLS_ECDHE_RSA_WITH_RC4_128_SHA", "TLS_ECDHE_ECDSA_WITH_3DES_EDE_CBC_SHA", "TLS_ECDHE_RSA_WITH_3DES_EDE_CBC_SHA", "TLS_ECDHE_ECDSA_WITH_NULL_SHA", "TLS_ECDHE_RSA_WITH_NULL_SHA", "TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256", "TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384", "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256", "TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384", "TLS_ECDHE_PSK_WITH_RC4_128_SHA", "TLS_ECDHE_PSK_WITH_3DES_EDE_CBC_SHA", "TLS_ECDHE_PSK_WITH_AES_128_CBC_SHA", "TLS_ECDHE_PSK_WITH_AES_256_CBC_SHA", "TLS_ECDHE_PSK_WITH_AES_128_CBC_SHA256", "TLS_ECDHE_PSK_WITH_AES_256_CBC_SHA384", "TLS_ECDHE_PSK_WITH_NULL_SHA", "TLS_ECDHE_PSK_WITH_NULL_SHA256", "TLS_ECDHE_PSK_WITH_NULL_SHA384"};
    public static final String[] RC4_CIPHERS = new String[]{"SSL_DH_anon_EXPORT_WITH_RC4_40_MD5", "SSL_DH_anon_WITH_RC4_128_MD5", "SSL_DHE_DSS_EXPORT1024_WITH_RC4_56_SHA", "SSL_DHE_DSS_WITH_RC4_128_SHA", "SSL_RSA_EXPORT1024_WITH_RC4_56_SHA", "SSL_RSA_EXPORT_WITH_RC4_40_MD5", "SSL_RSA_WITH_RC4_128_MD5", "SSL_RSA_WITH_RC4_128_SHA", "TLS_DHE_PSK_WITH_RC4_128_SHA", "TLS_ECDH_anon_WITH_RC4_128_SHA", "TLS_ECDH_ECDSA_WITH_RC4_128_SHA", "TLS_ECDHE_ECDSA_WITH_RC4_128_SHA", "TLS_ECDHE_PSK_WITH_RC4_128_SHA", "TLS_ECDHE_RSA_WITH_RC4_128_SHA", "TLS_ECDH_RSA_WITH_RC4_128_SHA", "TLS_KRB5_EXPORT_WITH_RC4_40_MD5", "TLS_KRB5_EXPORT_WITH_RC4_40_SHA", "TLS_KRB5_WITH_RC4_128_MD5", "TLS_KRB5_WITH_RC4_128_SHA", "TLS_PSK_WITH_RC4_128_SHA", "TLS_RSA_PSK_WITH_RC4_128_SHA"};

    private Crypto() {
    }

    public static String[] getBannedCipherSuitesFromConfigurationValue(String value) {
        ArrayList values = Lists.newArrayList((Iterable)CIPHER_FLAG_SPLITTER.split((CharSequence)value));
        CipherFlag[] flags = new CipherFlag[values.size()];
        for (int i = 0; i < values.size(); ++i) {
            flags[i] = CipherFlag.valueOf((String)values.get(i));
        }
        return Crypto.getBannedCipherSuites(flags);
    }

    public static String[] getBannedCipherSuites(CipherFlag[] flags) {
        HashSet<String> banned = new HashSet<String>();
        block4: for (CipherFlag flag : flags) {
            switch (flag) {
                case DISABLE_EC: {
                    banned.addAll(Arrays.asList(EC_CIPHERS));
                    continue block4;
                }
                case DISABLE_RC4: {
                    banned.addAll(Arrays.asList(RC4_CIPHERS));
                }
            }
        }
        return banned.toArray(new String[banned.size()]);
    }

    public static enum CipherFlag {
        DISABLE_EC,
        DISABLE_RC4;

    }
}

