/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.util;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class ReflectionUtils {
    private static final Map<String, Method> methodCache = new HashMap<String, Method>();

    public static Method resolve(Class<?> c, String name, Class<?> ... parameters) {
        try {
            Object[] signature = new Object[]{c, name, parameters};
            String key = Arrays.deepToString(signature);
            Method m = methodCache.get(key);
            if (m != null) {
                return m;
            }
            m = c.getMethod(name, parameters);
            methodCache.put(key, m);
            return m;
        }
        catch (NoSuchMethodException e) {
            for (int i = 0; i < parameters.length; ++i) {
                Class<?> s = parameters[i].getSuperclass();
                if (s == null) continue;
                Class<?> old = parameters[i];
                parameters[i] = s;
                Method m = ReflectionUtils.resolve(c, name, parameters);
                if (m != null) {
                    return m;
                }
                parameters[i] = old;
            }
            return null;
        }
    }

    public static boolean hasDeclaredException(Method method, Exception exception) {
        for (Class<?> clazz : method.getExceptionTypes()) {
            if (!clazz.isAssignableFrom(exception.getClass())) continue;
            return true;
        }
        return false;
    }

    public static Method getAnyMethod(Class<?> clazz, String name, Class<?> ... parameterTypes) throws NoSuchMethodException {
        try {
            return clazz.getDeclaredMethod(name, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            Class<?> superclass = clazz.getSuperclass();
            if (superclass != null) {
                return ReflectionUtils.getAnyMethod(superclass, name, parameterTypes);
            }
            throw e;
        }
    }
}

