/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class TimeUtils {
    public static final String TIMESTAMP_FORMAT = "yyyy-MM-dd' 'HH:mm:ss.SSS";
    private static final ImmutableMap<TimeUnit, String> SHORT_TIMEUNIT_NAMES = ImmutableMap.builder().put((Object)TimeUnit.NANOSECONDS, (Object)"ns").put((Object)TimeUnit.MICROSECONDS, (Object)"\u00b5s").put((Object)TimeUnit.MILLISECONDS, (Object)"ms").put((Object)TimeUnit.SECONDS, (Object)"s").put((Object)TimeUnit.MINUTES, (Object)"min").put((Object)TimeUnit.HOURS, (Object)"hours").put((Object)TimeUnit.DAYS, (Object)"days").build();
    private static final ImmutableMap<TimeUnit, String> LONG_TIMEUNIT_NAMES = ImmutableMap.builder().put((Object)TimeUnit.NANOSECONDS, (Object)"nanoseconds").put((Object)TimeUnit.MICROSECONDS, (Object)"microseconds").put((Object)TimeUnit.MILLISECONDS, (Object)"milliseconds").put((Object)TimeUnit.SECONDS, (Object)"seconds").put((Object)TimeUnit.MINUTES, (Object)"minutes").put((Object)TimeUnit.HOURS, (Object)"hours").put((Object)TimeUnit.DAYS, (Object)"days").build();
    private static final DecreasingTimeUnitComparator comparator = new DecreasingTimeUnitComparator();

    private TimeUtils() {
    }

    public static CharSequence duration(long duration, TimeUnit units, TimeUnitFormat unitFormat) {
        return TimeUtils.appendDuration(new StringBuilder(), duration, units, unitFormat);
    }

    public static String getFormattedDuration(long duration, TimeUnit unit, String format) {
        return new DurationFormatter(format).format(duration, unit);
    }

    public static String unitStringOf(TimeUnit unit) {
        return (String)SHORT_TIMEUNIT_NAMES.get((Object)unit);
    }

    public static StringBuilder appendDuration(StringBuilder sb, long duration, TimeUnit units, TimeUnitFormat unitFormat) {
        ImmutableMap<TimeUnit, String> unitsFormat;
        Preconditions.checkArgument((duration >= 0L ? 1 : 0) != 0);
        ImmutableMap<TimeUnit, String> immutableMap = unitsFormat = unitFormat == TimeUnitFormat.SHORT ? SHORT_TIMEUNIT_NAMES : LONG_TIMEUNIT_NAMES;
        if (units == TimeUnit.NANOSECONDS && duration < TimeUnit.MICROSECONDS.toNanos(2L)) {
            sb.append(units.toNanos(duration)).append(' ').append((String)unitsFormat.get((Object)TimeUnit.NANOSECONDS));
            return sb;
        }
        if (units.toMicros(duration) < TimeUnit.MILLISECONDS.toMillis(2L) && units.compareTo(TimeUnit.MICROSECONDS) <= 0) {
            sb.append(units.toMicros(duration)).append(' ').append((String)unitsFormat.get((Object)TimeUnit.MICROSECONDS));
            return sb;
        }
        long durationInMillis = units.toMillis(duration);
        if (durationInMillis < TimeUnit.SECONDS.toMillis(2L) && units.compareTo(TimeUnit.MILLISECONDS) <= 0) {
            sb.append(durationInMillis).append(' ').append((String)unitsFormat.get((Object)TimeUnit.MILLISECONDS));
        } else if (durationInMillis < TimeUnit.MINUTES.toMillis(2L) && units.compareTo(TimeUnit.SECONDS) <= 0) {
            sb.append(units.toSeconds(duration)).append(' ').append((String)unitsFormat.get((Object)TimeUnit.SECONDS));
        } else if (durationInMillis < TimeUnit.HOURS.toMillis(2L) && units.compareTo(TimeUnit.MINUTES) <= 0) {
            sb.append(units.toMinutes(duration)).append(' ').append((String)unitsFormat.get((Object)TimeUnit.MINUTES));
        } else if (durationInMillis < TimeUnit.DAYS.toMillis(2L) && units.compareTo(TimeUnit.HOURS) <= 0) {
            sb.append(units.toHours(duration)).append(' ').append((String)unitsFormat.get((Object)TimeUnit.HOURS));
        } else {
            sb.append(units.toDays(duration)).append(' ').append((String)unitsFormat.get((Object)TimeUnit.DAYS));
        }
        return sb;
    }

    public static CharSequence relativeTimestamp(long when, long current) {
        return TimeUtils.appendRelativeTimestamp(new StringBuilder(), when, current);
    }

    public static StringBuilder appendRelativeTimestamp(StringBuilder sb, long when, long current) {
        Preconditions.checkArgument((when > 0L ? 1 : 0) != 0);
        Preconditions.checkArgument((current > 0L ? 1 : 0) != 0);
        SimpleDateFormat iso8601 = new SimpleDateFormat(TIMESTAMP_FORMAT);
        sb.append(iso8601.format(new Date(when)));
        long diff = Math.abs(when - current);
        sb.append(" (");
        TimeUtils.appendDuration(sb, diff, TimeUnit.MILLISECONDS, TimeUnitFormat.LONG);
        sb.append(' ');
        sb.append(when < current ? "ago" : "in the future");
        sb.append(')');
        return sb;
    }

    public static enum TimeUnitFormat {
        SHORT,
        LONG;

    }

    public static class DurationFormatter {
        private final String format;
        private DurationParser durations;

        public DurationFormatter(String format) {
            Preconditions.checkNotNull((Object)format, (Object)"Format string must be specified.");
            this.format = format;
        }

        public String format(long duration, TimeUnit unit) {
            Preconditions.checkNotNull((Object)((Object)unit), (Object)"Duration time unit must be specified.");
            TimeUnit[] sortedDimensions = this.getSortedDimensions();
            this.durations = new DurationParser(duration, unit);
            for (TimeUnit dimension : sortedDimensions) {
                this.durations.parse(dimension);
            }
            StringBuilder builder = new StringBuilder();
            this.replace(builder);
            return builder.toString();
        }

        private TimeUnit[] getSortedDimensions() {
            HashSet<TimeUnit> units = new HashSet<TimeUnit>();
            char[] sequence = this.format.toCharArray();
            block11: for (int c = 0; c < sequence.length; ++c) {
                switch (sequence[c]) {
                    case '%': {
                        switch (sequence[++c]) {
                            case 'D': {
                                units.add(TimeUnit.DAYS);
                                continue block11;
                            }
                            case 'H': {
                                units.add(TimeUnit.HOURS);
                                continue block11;
                            }
                            case 'm': {
                                units.add(TimeUnit.MINUTES);
                                continue block11;
                            }
                            case 's': {
                                units.add(TimeUnit.SECONDS);
                                continue block11;
                            }
                            case 'S': {
                                units.add(TimeUnit.MILLISECONDS);
                                continue block11;
                            }
                            case 'N': {
                                units.add(TimeUnit.MILLISECONDS);
                                units.add(TimeUnit.MICROSECONDS);
                                units.add(TimeUnit.NANOSECONDS);
                                continue block11;
                            }
                        }
                        throw new IllegalArgumentException("No such formatting symbol " + c);
                    }
                }
            }
            TimeUnit[] sorted = units.toArray(new TimeUnit[units.size()]);
            Arrays.sort(sorted, comparator);
            return sorted;
        }

        private void replace(StringBuilder builder) {
            char[] sequence = this.format.toCharArray();
            block3: for (int c = 0; c < sequence.length; ++c) {
                switch (sequence[c]) {
                    case '%': {
                        ++c;
                        c = this.handlePlaceholder(c, sequence, builder);
                        continue block3;
                    }
                    default: {
                        builder.append(sequence[c]);
                    }
                }
            }
        }

        private int handlePlaceholder(int c, char[] sequence, StringBuilder builder) {
            switch (sequence[c]) {
                case 'D': {
                    builder.append(this.durations.get(TimeUnit.DAYS));
                    break;
                }
                case 'H': {
                    if (sequence[c + 1] == 'H') {
                        ++c;
                        builder.append(this.leadingZero(this.durations.get(TimeUnit.HOURS)));
                        break;
                    }
                    builder.append(this.durations.get(TimeUnit.HOURS));
                    break;
                }
                case 'm': {
                    if (sequence[c + 1] == 'm') {
                        ++c;
                        builder.append(this.leadingZero(this.durations.get(TimeUnit.MINUTES)));
                        break;
                    }
                    builder.append(this.durations.get(TimeUnit.MINUTES));
                    break;
                }
                case 's': {
                    if (sequence[c + 1] == 's') {
                        ++c;
                        builder.append(this.leadingZero(this.durations.get(TimeUnit.SECONDS)));
                        break;
                    }
                    builder.append(this.durations.get(TimeUnit.SECONDS));
                    break;
                }
                case 'S': {
                    builder.append(this.durations.get(TimeUnit.MILLISECONDS));
                    break;
                }
                case 'N': {
                    builder.append(this.durations.get(TimeUnit.MILLISECONDS)).append(this.durations.get(TimeUnit.MICROSECONDS)).append(this.durations.get(TimeUnit.NANOSECONDS));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("No such formatting symbol " + c);
                }
            }
            return c;
        }

        private String leadingZero(Long value) {
            String valueString = String.valueOf(value);
            if (valueString.length() < 2) {
                return "0" + valueString;
            }
            return valueString;
        }
    }

    public static class DurationParser {
        private final Map<TimeUnit, Long> durations;
        private final Long duration;
        private final TimeUnit durationUnit;
        private TimeUnit current;
        private long remainder;

        public DurationParser(Long duration, TimeUnit durationUnit) {
            this.duration = (Long)Preconditions.checkNotNull((Object)duration, (Object)"duration was null");
            this.durationUnit = (TimeUnit)((Object)Preconditions.checkNotNull((Object)((Object)durationUnit), (Object)"durationUnit was null"));
            this.durations = new HashMap<TimeUnit, Long>();
            this.remainder = durationUnit.toNanos(duration);
        }

        public DurationParser parseAll() {
            this.parse(TimeUnit.DAYS);
            this.parse(TimeUnit.HOURS);
            this.parse(TimeUnit.MINUTES);
            this.parse(TimeUnit.SECONDS);
            this.parse(TimeUnit.MILLISECONDS);
            this.parse(TimeUnit.MICROSECONDS);
            this.parse(TimeUnit.NANOSECONDS);
            return this;
        }

        public void parse(TimeUnit unit) throws IllegalStateException {
            this.checkStrictlyDecreasing(unit);
            long durationForUnit = unit.convert(this.remainder, TimeUnit.NANOSECONDS);
            long durationInNanos = unit.toNanos(durationForUnit);
            this.remainder -= durationInNanos;
            this.durations.put(unit, durationForUnit);
            this.current = unit;
        }

        public void clear() {
            this.durations.clear();
            this.current = null;
            this.remainder = this.durationUnit.toNanos(this.duration);
        }

        public long get(TimeUnit unit) {
            Long duration = this.durations.get((Object)unit);
            return duration == null ? 0L : duration;
        }

        private void checkStrictlyDecreasing(TimeUnit next) throws IllegalStateException {
            if (comparator.compare(next, this.current) <= 0) {
                throw new IllegalStateException((Object)((Object)next) + " is not strictly " + "smaller than " + (Object)((Object)this.current));
            }
        }
    }

    public static class DecreasingTimeUnitComparator
    implements Comparator<TimeUnit> {
        @Override
        public int compare(TimeUnit unit1, TimeUnit unit2) {
            long nanos2;
            if (unit1 == null) {
                return -1;
            }
            if (unit2 == null) {
                return 1;
            }
            long nanos1 = unit1.toNanos(1L);
            if (nanos1 == (nanos2 = unit2.toNanos(1L))) {
                return 0;
            }
            if (nanos1 < nanos2) {
                return 1;
            }
            return -1;
        }
    }
}

