/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.util;

import java.io.ObjectStreamException;
import java.io.Serializable;

public final class AccessLatency
implements Serializable {
    private static final long serialVersionUID = -6473179157424112725L;
    private final String _name;
    private final int _id;
    public static final AccessLatency ONLINE = new AccessLatency("ONLINE", 1);
    public static final AccessLatency NEARLINE = new AccessLatency("NEARLINE", 0);
    private static final AccessLatency[] ALL_LATENCIES = new AccessLatency[]{ONLINE, NEARLINE};

    private AccessLatency(String name, int id) {
        this._name = name;
        this._id = id;
    }

    public static AccessLatency[] getAllLatencies() {
        return ALL_LATENCIES;
    }

    public String toString() {
        return this._name;
    }

    public int getId() {
        return this._id;
    }

    public static AccessLatency getAccessLatency(String latency) throws IllegalArgumentException {
        if (latency == null || latency.equalsIgnoreCase("null")) {
            throw new NullPointerException(" null state ");
        }
        for (AccessLatency al : AccessLatency.getAllLatencies()) {
            if (!al._name.equalsIgnoreCase(latency)) continue;
            return al;
        }
        try {
            int id = Integer.parseInt(latency);
            return AccessLatency.getAccessLatency(id);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Unknown AccessLatency");
        }
    }

    public static AccessLatency getAccessLatency(int id) throws IllegalArgumentException {
        for (AccessLatency al : AccessLatency.getAllLatencies()) {
            if (al._id != id) continue;
            return al;
        }
        throw new IllegalArgumentException("Unknown AccessLatency Id");
    }

    public boolean equals(Object obj) {
        return obj instanceof AccessLatency && ((AccessLatency)obj).getId() == this.getId();
    }

    public int hashCode() {
        return this._name.hashCode();
    }

    public static AccessLatency valueOf(String value) {
        return AccessLatency.getAccessLatency(value);
    }

    public Object readResolve() throws ObjectStreamException {
        return AccessLatency.getAccessLatency(this.getId());
    }
}

