/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.util;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import org.dcache.util.Exceptions;

public abstract class FsPath
implements Serializable {
    private static final long serialVersionUID = -4852395244086808172L;
    public static final FsPath ROOT = new Root();

    public static <E extends Exception> void checkChildName(String name, Function<String, E> toException) throws E {
        Exceptions.genericCheck(!name.isEmpty(), toException, "Name must be non-empty.", new Object[0]);
        Exceptions.genericCheck(!name.contains("/"), toException, "Name must not contain '/'.", new Object[0]);
        Exceptions.genericCheck(!name.equals("."), toException, "Name must not be '.'.", new Object[0]);
        Exceptions.genericCheck(!name.equals(".."), toException, "Name must not be '..'.", new Object[0]);
    }

    public static FsPath create(String path) {
        Preconditions.checkArgument((boolean)path.startsWith("/"), (String)"Not an absolute path: %s", (Object)path);
        return ROOT.resolve(path.substring(1));
    }

    public static FsPath valueOf(String path) {
        return FsPath.create(path);
    }

    public String toString() {
        return this.appendTo(new StringBuilder()).toString();
    }

    protected abstract StringBuilder appendTo(StringBuilder var1);

    protected abstract StringBuilder appendTo2(StringBuilder var1);

    protected abstract FsPath tryDropLength(FsPath var1);

    protected abstract FsPath dropLength(FsPath var1);

    protected abstract boolean isSuffix(Iterator<String> var1);

    protected abstract boolean contains(List<String> var1);

    public boolean contains(String path) {
        return this.contains(Lists.reverse((List)Splitter.on((String)"/").omitEmptyStrings().splitToList((CharSequence)path)));
    }

    public abstract boolean isRoot();

    public abstract FsPath parent();

    public abstract String name();

    public abstract int length();

    public abstract FsPath drop(int var1);

    public FsPath resolve(String path) {
        int i = path.lastIndexOf(47);
        switch (i) {
            case -1: {
                return this.resolvePathElement(ROOT, path);
            }
            case 0: {
                return ROOT.resolvePathElement(ROOT, path.substring(1));
            }
        }
        return this.resolve(path.substring(0, i)).resolvePathElement(ROOT, path.substring(i + 1));
    }

    public FsPath chroot(String path) {
        int i = path.lastIndexOf(47);
        switch (i) {
            case -1: {
                return this.resolvePathElement(this, path);
            }
            case 0: {
                return this.resolvePathElement(this, path.substring(1));
            }
        }
        return this.chroot(path.substring(0, i)).resolvePathElement(this, path.substring(i + 1));
    }

    private FsPath resolvePathElement(FsPath root, String name) {
        switch (name) {
            case "": 
            case ".": {
                return this;
            }
            case "..": {
                return this == root ? this : this.parent();
            }
        }
        return new Child(this, name);
    }

    public FsPath child(String name) {
        FsPath.checkChildName(name, IllegalArgumentException::new);
        return new Child(this, name);
    }

    public boolean hasPrefix(FsPath prefix) {
        FsPath delta = this.tryDropLength(prefix);
        return delta != null && prefix.equals(this.dropLength(delta));
    }

    public String stripPrefix(FsPath prefix) {
        FsPath delta = this.dropLength(prefix);
        return this.appendSuffix(prefix, delta, new StringBuilder()).toString();
    }

    protected abstract StringBuilder appendSuffix(FsPath var1, FsPath var2, StringBuilder var3);

    protected abstract StringBuilder appendSuffix2(FsPath var1, FsPath var2, StringBuilder var3);

    protected abstract void write(ObjectOutput var1, int var2) throws IOException;

    protected FsPath read(ObjectInput in, int len) throws IOException {
        return len == 0 ? this : this.child(in.readUTF()).read(in, len - 1);
    }

    private Object writeReplace() throws ObjectStreamException {
        return new SerializedPath(this);
    }

    private static class SerializedPath
    implements Externalizable {
        private static final long serialVersionUID = 2301167077307955976L;
        private transient FsPath path;

        public SerializedPath() {
        }

        public SerializedPath(FsPath path) {
            this.path = path;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            this.path.write(out, 0);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.path = ROOT.read(in, in.readShort());
        }

        private Object readResolve() {
            return this.path;
        }
    }

    private static final class Child
    extends FsPath {
        private final FsPath parent;
        private final String name;

        private Child(FsPath parent, String name) {
            this.parent = parent;
            this.name = name;
        }

        @Override
        protected StringBuilder appendTo(StringBuilder path) {
            return this.parent.appendTo2(path).append(this.name);
        }

        @Override
        protected StringBuilder appendTo2(StringBuilder path) {
            return this.appendTo(path).append('/');
        }

        @Override
        public boolean isRoot() {
            return false;
        }

        @Override
        public FsPath parent() {
            return this.parent;
        }

        public int hashCode() {
            return 31 * this.parent.hashCode() + this.name.hashCode();
        }

        public boolean equals(Object o) {
            if (!(o instanceof FsPath)) {
                return false;
            }
            FsPath other = (FsPath)o;
            return !other.isRoot() && this.name().equals(other.name()) && this.parent().equals(other.parent());
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public int length() {
            return this.parent().length() + 1;
        }

        @Override
        public FsPath drop(int n) {
            Preconditions.checkArgument((n >= 0 ? 1 : 0) != 0);
            return n == 0 ? this : this.parent().drop(n - 1);
        }

        @Override
        protected FsPath tryDropLength(FsPath path) {
            return path.isRoot() ? this : this.parent().tryDropLength(path.parent());
        }

        @Override
        protected FsPath dropLength(FsPath path) {
            return path.isRoot() ? this : this.parent().dropLength(path.parent());
        }

        @Override
        protected boolean isSuffix(Iterator<String> path) {
            return !path.hasNext() || path.next().equals(this.name()) && this.parent().isSuffix(path);
        }

        @Override
        protected boolean contains(List<String> path) {
            return this.isSuffix(path.iterator()) || this.parent().contains(path);
        }

        @Override
        protected StringBuilder appendSuffix(FsPath prefix, FsPath length, StringBuilder s) {
            if (length.isRoot()) {
                if (!this.equals(prefix)) {
                    throw new IllegalArgumentException(prefix + " is not a prefix of " + this);
                }
                return s;
            }
            return this.parent().appendSuffix2(prefix, length.parent(), s).append(this.name());
        }

        @Override
        protected StringBuilder appendSuffix2(FsPath prefix, FsPath length, StringBuilder s) {
            return this.appendSuffix(prefix, length, s).append('/');
        }

        @Override
        protected void write(ObjectOutput out, int len) throws IOException {
            this.parent.write(out, len + 1);
            out.writeUTF(this.name);
        }
    }

    private static final class Root
    extends FsPath {
        private Root() {
        }

        @Override
        protected StringBuilder appendTo(StringBuilder path) {
            return this.appendTo2(path);
        }

        @Override
        protected StringBuilder appendTo2(StringBuilder path) {
            return path.append('/');
        }

        @Override
        public boolean isRoot() {
            return true;
        }

        @Override
        public FsPath parent() {
            throw new IllegalStateException("Root does not have a parent");
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object o) {
            return o instanceof Root;
        }

        @Override
        public String name() {
            return "/";
        }

        @Override
        public int length() {
            return 0;
        }

        @Override
        public FsPath drop(int n) {
            Preconditions.checkArgument((n >= 0 ? 1 : 0) != 0);
            return this;
        }

        @Override
        protected FsPath tryDropLength(FsPath path) {
            return path.isRoot() ? this : null;
        }

        @Override
        protected FsPath dropLength(FsPath path) {
            return this;
        }

        @Override
        protected boolean isSuffix(Iterator<String> path) {
            return !path.hasNext();
        }

        @Override
        protected boolean contains(List<String> path) {
            return path.isEmpty();
        }

        @Override
        protected StringBuilder appendSuffix(FsPath prefix, FsPath length, StringBuilder s) {
            return this.appendSuffix2(prefix, length, s);
        }

        @Override
        protected StringBuilder appendSuffix2(FsPath prefix, FsPath length, StringBuilder s) {
            if (!prefix.isRoot()) {
                throw new IllegalArgumentException(prefix + " is not a prefix of " + this);
            }
            return s.append('/');
        }

        @Override
        protected void write(ObjectOutput out, int len) throws IOException {
            out.writeShort(len);
        }
    }
}

