/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Pgpass {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"diskCacheV111.util.Pgpass");
    private final String _pwdfile;
    private String _hostname;
    private String _port;
    private String _database;
    private String _username;

    public Pgpass(String pwdfile) {
        this._pwdfile = pwdfile;
    }

    private String process(String line, String hostname, String port, String database, String username) {
        String[] sa;
        if (line.charAt(0) != '#' && ((sa = line.split(":"))[0].equals("*") || sa[0].equals(hostname)) && (sa[1].equals("*") || sa[1].equals(port)) && (sa[2].equals("*") || sa[2].equals(database)) && (sa[3].equals("*") || sa[3].equals(username))) {
            return sa[4];
        }
        return null;
    }

    private String stripProperties(String s) {
        int i = s.indexOf(63);
        if (i != -1) {
            return s.substring(0, i);
        }
        return s;
    }

    private boolean parseUrl(String url) {
        String[] r = url.split("/");
        this._hostname = "localhost";
        this._port = "5432";
        if (r.length == 1) {
            String[] r1 = r[0].split(":");
            this._database = this.stripProperties(r1[r1.length - 1]);
        } else if (r.length == 4) {
            this._database = this.stripProperties(r[r.length - 1]);
            String[] r1 = r[2].split(":");
            this._hostname = r1[0];
            if (r1.length == 2) {
                this._port = r1[1];
            } else if (r1.length > 2) {
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    public String getPgpass(String hostname, String port, String database, String username) {
        String result;
        if (!this.checkIfFileExists()) {
            LOGGER.warn("File '{}' not exist", (Object)this._pwdfile);
            return null;
        }
        try {
            if (!this.checkPgFilePermissions("rw-------")) {
                LOGGER.warn("Protection for '{}' must be '600'", (Object)this._pwdfile);
                return null;
            }
            result = this.parsePgFile(hostname, port, database, username);
        }
        catch (IOException e) {
            LOGGER.warn("'{}': I/O error", (Object)this._pwdfile);
            return null;
        }
        return result;
    }

    private boolean checkIfFileExists() {
        return new File(this._pwdfile).isFile();
    }

    private boolean checkPgFilePermissions(String referencePermissionInput) throws IOException {
        if (this.checkIfOsIsPosixCompliant()) {
            return this.checkPgFilePermissionsForPosix(referencePermissionInput);
        }
        LOGGER.warn("Error reading permissions for '{}'. OS is not POSIX compliant", (Object)this._pwdfile);
        return false;
    }

    private boolean checkIfOsIsPosixCompliant() {
        return FileSystems.getDefault().supportedFileAttributeViews().contains("posix");
    }

    private String parsePgFile(String hostname, String port, String database, String username) throws IOException {
        String line;
        BufferedReader in = new BufferedReader(new FileReader(this._pwdfile));
        String r = null;
        while ((line = in.readLine()) != null && r == null) {
            r = this.process(line, hostname, port, database, username);
        }
        in.close();
        return r;
    }

    private boolean checkPgFilePermissionsForPosix(String referencePermissionInput) throws IOException {
        Path path = Paths.get(this._pwdfile, new String[0]);
        Set<PosixFilePermission> filePermissions = Files.getPosixFilePermissions(path, new LinkOption[0]);
        Set<PosixFilePermission> referencePermissions = PosixFilePermissions.fromString(referencePermissionInput);
        boolean result = filePermissions.equals(referencePermissions);
        return result;
    }

    public String getPgpass(String url, String username) {
        if (this.parseUrl(url)) {
            return this.getPgpass(this._hostname, this._port, this._database, username);
        }
        return null;
    }

    public String getHostname() {
        return this._hostname;
    }

    public String getPort() {
        return this._port;
    }

    public String getDatabase() {
        return this._database;
    }

    public static String getPassword(String file, String url, String user, String password) {
        if (file != null && !file.trim().isEmpty()) {
            Pgpass pgpass = new Pgpass(file);
            return pgpass.getPgpass(url, user);
        }
        return password;
    }
}

