/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.util;

import java.io.ObjectStreamException;
import java.io.Serializable;

public final class RetentionPolicy
implements Serializable {
    private static final long serialVersionUID = -2206085171393244383L;
    private final String _name;
    private final int _id;
    public static final RetentionPolicy REPLICA = new RetentionPolicy("REPLICA", 2);
    public static final RetentionPolicy OUTPUT = new RetentionPolicy("OUTPUT", 1);
    public static final RetentionPolicy CUSTODIAL = new RetentionPolicy("CUSTODIAL", 0);
    private static final RetentionPolicy[] ALL_POLICIES = new RetentionPolicy[]{REPLICA, OUTPUT, CUSTODIAL};

    private RetentionPolicy(String name, int id) {
        this._name = name;
        this._id = id;
    }

    public static RetentionPolicy[] getAllPolicies() {
        return ALL_POLICIES;
    }

    public String toString() {
        return this._name;
    }

    public int getId() {
        return this._id;
    }

    public static RetentionPolicy getRetentionPolicy(String policy) throws IllegalArgumentException {
        if (policy == null || policy.equalsIgnoreCase("null")) {
            throw new NullPointerException(" null state ");
        }
        for (RetentionPolicy rp : RetentionPolicy.getAllPolicies()) {
            if (!rp._name.equalsIgnoreCase(policy)) continue;
            return rp;
        }
        try {
            int id = Integer.parseInt(policy);
            return RetentionPolicy.getRetentionPolicy(id);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Unknown Policy: \"" + policy + "\"");
        }
    }

    public static RetentionPolicy getRetentionPolicy(int id) throws IllegalArgumentException {
        for (RetentionPolicy rp : RetentionPolicy.getAllPolicies()) {
            if (rp._id != id) continue;
            return rp;
        }
        throw new IllegalArgumentException("Unknown policy Id: " + id);
    }

    public static RetentionPolicy valueOf(String value) {
        return RetentionPolicy.getRetentionPolicy(value);
    }

    public boolean equals(Object obj) {
        return obj instanceof RetentionPolicy && ((RetentionPolicy)obj).getId() == this.getId();
    }

    public int hashCode() {
        return this._name.hashCode();
    }

    public Object readResolve() throws ObjectStreamException {
        return RetentionPolicy.getRetentionPolicy(this.getId());
    }
}

