/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.alarms;

import java.util.Objects;
import org.dcache.alarms.PredefinedAlarm;
import org.slf4j.IMarkerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public final class AlarmMarkerFactory {
    private static final String ALARM_MARKER = "ALARM";
    private static final String ALARM_MARKER_TYPE = "ALARM_TYPE";
    private static final String ALARM_MARKER_KEY = "ALARM_KEY";
    private static final IMarkerFactory factory = MarkerFactory.getIMarkerFactory();

    public static Marker getMarker() {
        return AlarmMarkerFactory.getMarker(null, null);
    }

    public static Marker getMarker(PredefinedAlarm type) {
        return AlarmMarkerFactory.getMarker(type, null);
    }

    public static Marker getMarker(PredefinedAlarm type, String ... keywords) {
        Marker alarmMarker = factory.getDetachedMarker(ALARM_MARKER);
        if (type == null) {
            return alarmMarker;
        }
        Marker typeMarker = factory.getDetachedMarker(ALARM_MARKER_TYPE);
        Marker alarmType = factory.getDetachedMarker(type.toString());
        typeMarker.add(alarmType);
        alarmMarker.add(typeMarker);
        if (keywords != null) {
            Marker keyMarker = factory.getDetachedMarker(ALARM_MARKER_KEY);
            for (String keyword : keywords) {
                Marker alarmKey = factory.getDetachedMarker(keyword);
                keyMarker.add(alarmKey);
            }
            alarmMarker.add(keyMarker);
        }
        return alarmMarker;
    }

    public static boolean containsAlarmMarker(Marker marker) {
        return marker != null && marker.contains(ALARM_MARKER);
    }

    public static Marker getKeySubmarker(Marker marker) {
        return AlarmMarkerFactory.getSubmarker(marker, ALARM_MARKER_KEY);
    }

    public static Marker getTypeSubmarker(Marker marker) {
        return AlarmMarkerFactory.getSubmarker(marker, ALARM_MARKER_TYPE);
    }

    private static Marker getSubmarker(Marker marker, String name) {
        Objects.requireNonNull(marker);
        Objects.requireNonNull(name);
        for (Marker next : marker) {
            if (!name.equals(next.getName())) continue;
            return next;
        }
        return null;
    }
}

