/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.auth;

import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Optional;
import javax.security.auth.Subject;
import org.dcache.util.Strings;

public class BearerTokenCredential
implements Serializable {
    private static final long serialVersionUID = -5933313664563503235L;
    private final String _token;

    public static Optional<String> getBearerTokenFromSubject(Subject subject) {
        return subject.getPrivateCredentials().stream().filter(t -> t instanceof BearerTokenCredential).map(BearerTokenCredential.class::cast).findAny().map(BearerTokenCredential::getToken);
    }

    public BearerTokenCredential(String token) {
        Preconditions.checkArgument((boolean)CharMatcher.ascii().matchesAllOf((CharSequence)token), (Object)"Bearer Token not ASCII");
        this._token = token;
    }

    public String getToken() {
        return this._token;
    }

    private String hash(String in) {
        return "Hash=" + Strings.base64Hash(in);
    }

    public String describeToken() {
        int length = this._token.length();
        if (length <= 8) {
            return this.hash(this._token);
        }
        String head = this._token.substring(0, 4);
        String middle = this._token.substring(4, length - 4);
        String tail = this._token.substring(length - 4, length);
        return head + "+{" + this.hash(middle) + "}+" + tail;
    }

    public int hashCode() {
        return this._token.hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BearerTokenCredential)) {
            return false;
        }
        BearerTokenCredential other = (BearerTokenCredential)o;
        return this._token.equals(other._token);
    }

    public String toString() {
        return BearerTokenCredential.class.getSimpleName() + "[" + this.describeToken() + "]";
    }
}

