/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.auth;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.security.Principal;
import java.util.regex.Pattern;
import org.dcache.auth.AuthenticationOutput;

@AuthenticationOutput
public class EmailAddressPrincipal
implements Principal,
Serializable {
    private static final long serialVersionUID = -5091924321331479809L;
    private static final Pattern EMAIL_PATTERN = Pattern.compile("^[a-zA-Z0-9.!#$%&'*+/=?^_`{|}~-]+@((\\[[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\])|(([a-zA-Z\\-0-9]+\\.)+[a-zA-Z]{2,}))$", 2);
    private final String _email;

    public static boolean isValid(String email) {
        return EMAIL_PATTERN.matcher(email).matches();
    }

    public EmailAddressPrincipal(String email) {
        Preconditions.checkArgument((boolean)EMAIL_PATTERN.matcher(email).matches(), (Object)"Not a valid email address");
        this._email = email;
    }

    @Override
    public String getName() {
        return this._email;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EmailAddressPrincipal)) {
            return false;
        }
        EmailAddressPrincipal that = (EmailAddressPrincipal)o;
        return this._email.equals(that._email);
    }

    @Override
    public int hashCode() {
        return this._email.hashCode();
    }

    @Override
    public String toString() {
        return "EmailAddressPrincipal[" + this._email + "]";
    }
}

