/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.auth;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.security.Principal;
import org.dcache.auth.AuthenticationOutput;

@AuthenticationOutput
public class FullNamePrincipal
implements Principal,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String _fullName;

    public FullNamePrincipal(String fullName) {
        Preconditions.checkArgument((!fullName.isEmpty() ? 1 : 0) != 0, (Object)"Full Name not given");
        this._fullName = fullName;
    }

    public FullNamePrincipal(String givenName, String familyName) {
        Preconditions.checkArgument((!givenName.isEmpty() ? 1 : 0) != 0, (Object)"Missing given name");
        Preconditions.checkArgument((!familyName.isEmpty() ? 1 : 0) != 0, (Object)"Missing family name");
        this._fullName = Joiner.on((char)' ').skipNulls().join((Object)givenName, (Object)familyName, new Object[0]).trim();
    }

    @Override
    public String getName() {
        return this._fullName;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FullNamePrincipal)) {
            return false;
        }
        FullNamePrincipal that = (FullNamePrincipal)o;
        return this._fullName.equals(that._fullName);
    }

    @Override
    public int hashCode() {
        return this._fullName.hashCode();
    }

    @Override
    public String toString() {
        return "FullNamePrincipal[" + this._fullName + "]";
    }
}

