/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.auth;

import com.google.common.base.Preconditions;
import java.security.Principal;
import java.util.Objects;
import java.util.Optional;
import org.dcache.auth.LoA;

public class IGTFStatusPrincipal
implements Principal {
    private final String _name;
    private final boolean _isAccredited;
    private final LoA _loa;

    public IGTFStatusPrincipal(String name, boolean accredited, Optional<LoA> loa) {
        Preconditions.checkArgument((!name.isEmpty() ? 1 : 0) != 0);
        this._name = name;
        this._isAccredited = accredited;
        this._loa = loa.orElse(null);
    }

    @Override
    public String getName() {
        return this._name;
    }

    public boolean isAccredited() {
        return this._isAccredited;
    }

    public Optional<LoA> getLoA() {
        return Optional.ofNullable(this._loa);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this._name, this._loa}) ^ (this._isAccredited ? 1 : 0);
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof IGTFStatusPrincipal)) {
            return false;
        }
        IGTFStatusPrincipal that = (IGTFStatusPrincipal)other;
        return this._name.equals(that._name) && this._isAccredited == that._isAccredited && Objects.equals((Object)this._loa, (Object)that._loa);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("IGTFStatus[");
        if (this._isAccredited) {
            sb.append('*');
        }
        sb.append(this._name).append(']');
        return sb.toString();
    }
}

