/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.auth;

import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.dcache.auth.EntityDefinition;
import org.dcache.auth.LoA;

public class LoAs {
    private static final Map<LoA, LoA> GENERIC_EQUIVALENT_LOA = ImmutableMap.builder().put((Object)LoA.IGTF_AP_SLCS, (Object)LoA.IGTF_LOA_ASPEN).put((Object)LoA.IGTF_AP_MICS, (Object)LoA.IGTF_LOA_BIRCH).put((Object)LoA.IGTF_AP_CLASSIC, (Object)LoA.IGTF_LOA_CEDAR).put((Object)LoA.IGTF_AP_IOTA, (Object)LoA.IGTF_LOA_DOGWOOD).put((Object)LoA.REFEDS_IAP_HIGH, (Object)LoA.REFEDS_IAP_MEDIUM).put((Object)LoA.REFEDS_IAP_MEDIUM, (Object)LoA.REFEDS_IAP_LOW).build();
    private static final Map<LoA, LoA> PERSONAL_EQUIVALENT_LOA = ImmutableMap.builder().put((Object)LoA.IGTF_LOA_ASPEN, (Object)LoA.REFEDS_IAP_LOW).put((Object)LoA.IGTF_LOA_DOGWOOD, (Object)LoA.REFEDS_IAP_LOW).put((Object)LoA.IGTF_LOA_BIRCH, (Object)LoA.REFEDS_IAP_MEDIUM).put((Object)LoA.IGTF_LOA_CEDAR, (Object)LoA.REFEDS_IAP_MEDIUM).putAll(GENERIC_EQUIVALENT_LOA).build();

    private LoAs() {
    }

    public static EnumSet<LoA> withImpliedLoA(Optional<EntityDefinition> entity, Collection<LoA> asserted) {
        EnumSet additional;
        Map<LoA, LoA> mapping = entity.filter(EntityDefinition.PERSON::equals).map(e -> PERSONAL_EQUIVALENT_LOA).orElse(GENERIC_EQUIVALENT_LOA);
        EnumSet<LoA> result = EnumSet.copyOf(asserted);
        EnumSet considered = asserted;
        do {
            additional = considered.stream().map(mapping::get).filter(Objects::nonNull).collect(Collectors.toCollection(() -> EnumSet.noneOf(LoA.class)));
            result.addAll(additional);
        } while (!(considered = additional).isEmpty());
        return result;
    }
}

