/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.auth;

import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.security.Principal;
import java.util.Objects;
import org.dcache.auth.AuthenticationOutput;

@AuthenticationOutput
public class OidcSubjectPrincipal
implements Principal,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String _sub;
    private final String _op;

    public OidcSubjectPrincipal(String sub, String op) {
        Preconditions.checkArgument((boolean)CharMatcher.ascii().matchesAllOf((CharSequence)sub), (Object)"OpenId \"sub\" is not ASCII encoded");
        Preconditions.checkArgument((sub.length() <= 255 ? 1 : 0) != 0, (Object)"OpenId \"sub\" must not exceed 255 ASCII characters");
        this._sub = sub;
        this._op = Objects.requireNonNull(op);
    }

    @Override
    public String getName() {
        return this._sub + "@" + this._op;
    }

    public String getSubClaim() {
        return this._sub;
    }

    public String getOP() {
        return this._op;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof OidcSubjectPrincipal)) {
            return false;
        }
        OidcSubjectPrincipal other = (OidcSubjectPrincipal)obj;
        return this._sub.equals(other._sub) && this._op.equals(other._op);
    }

    @Override
    public int hashCode() {
        return this._sub.hashCode() ^ this._op.hashCode();
    }

    @Override
    public String toString() {
        return "OidcSubjectPrincipal[" + this._sub + "@" + this._op + "]";
    }
}

