/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.auth;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Objects;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthenticationException;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.dcache.auth.OpenIdCredential;
import org.dcache.auth.StaticOpenIdCredential;
import org.dcache.auth.WrappingOpenIdCredential;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenIdCredentialRefreshable
extends WrappingOpenIdCredential {
    private static final Logger LOG = LoggerFactory.getLogger(OpenIdCredentialRefreshable.class);
    private final HttpClient client;

    public OpenIdCredentialRefreshable(OpenIdCredential credential, HttpClient client) {
        super(Objects.requireNonNull(credential, "OpenId Credential can't be null"));
        this.client = Objects.requireNonNull(client, "Http Client can't be null");
    }

    @Override
    public String getBearerToken() {
        if (this.timeToRefresh()) {
            try {
                this.refreshOpenIdCredentials();
            }
            catch (IOException | AuthenticationException e) {
                LOG.warn("Error Refreshing OpenId Bearer Token with {}: {}", (Object)this.credential.getOpenidProvider(), (Object)e.getMessage());
            }
        }
        return this.credential.getBearerToken();
    }

    private synchronized void refreshOpenIdCredentials() throws IOException, AuthenticationException {
        HttpPost post = new HttpPost(this.credential.getOpenidProvider());
        BasicScheme scheme = new BasicScheme(StandardCharsets.UTF_8);
        UsernamePasswordCredentials clientCreds = new UsernamePasswordCredentials(this.credential.getClientCredential().getId(), this.credential.getClientCredential().getSecret());
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        params.add(new BasicNameValuePair("client_id", this.credential.getClientCredential().getId()));
        params.add(new BasicNameValuePair("client_secret", this.credential.getClientCredential().getSecret()));
        params.add(new BasicNameValuePair("grant_type", "refresh_token"));
        params.add(new BasicNameValuePair("refresh_token", this.credential.getRefreshToken()));
        params.add(new BasicNameValuePair("scope", this.credential.getScope()));
        post.setEntity((HttpEntity)new UrlEncodedFormEntity(params));
        post.addHeader(scheme.authenticate((Credentials)clientCreds, (HttpRequest)post, (HttpContext)new BasicHttpContext()));
        HttpResponse response = this.client.execute((HttpUriRequest)post);
        if (response.getStatusLine().getStatusCode() != 200) {
            throw new IOException(String.format("Error Refreshing OpenId Bearer Token [%s]: %s", response.getStatusLine().getStatusCode(), this.credential.getOpenidProvider()));
        }
        this.updateCredential(this.parseResponseToJson(response));
    }

    private boolean timeToRefresh() {
        return this.credential.getExpiresAt() - System.currentTimeMillis() < 60000L;
    }

    private JSONObject parseResponseToJson(HttpResponse response) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        response.getEntity().writeTo((OutputStream)os);
        return new JSONObject(new String(os.toByteArray(), StandardCharsets.UTF_8));
    }

    private void updateCredential(JSONObject json) throws IOException {
        try {
            this.credential = StaticOpenIdCredential.copyOf(this.credential).accessToken(json.getString("access_token")).expiry(json.getLong("expires_in")).build();
        }
        catch (JSONException je) {
            throw new IOException("Error Parsing response of OpenId Bearer Token Refresh: " + je.getMessage());
        }
    }
}

