/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.auth;

import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.security.Principal;

public class OpenIdGroupPrincipal
implements Principal,
Serializable {
    private final String group;

    public OpenIdGroupPrincipal(String group) {
        Preconditions.checkArgument((boolean)CharMatcher.ascii().matchesAllOf((CharSequence)group), (String)"OpenId \"group\": [%s] is not ASCII encoded", (Object)group);
        this.group = group;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OpenIdGroupPrincipal)) {
            return false;
        }
        OpenIdGroupPrincipal that = (OpenIdGroupPrincipal)o;
        return this.group.equals(that.group);
    }

    @Override
    public int hashCode() {
        return this.group.hashCode();
    }

    @Override
    public String getName() {
        return this.group;
    }

    @Override
    public String toString() {
        return "OpenIdGroup[" + this.getName() + "]";
    }
}

