/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.auth;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import com.google.common.net.InetAddresses;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.Principal;
import java.util.Objects;
import org.dcache.auth.AuthenticationInput;
import org.dcache.auth.AuthenticationOutput;

@AuthenticationInput
@AuthenticationOutput
public class Origin
implements Principal,
Serializable {
    private static final long serialVersionUID = -6791417439972410727L;
    private final InetAddress _address;
    private final ImmutableList<InetAddress> _clientChain;

    public Origin(InetAddress address) {
        this._address = Objects.requireNonNull(address);
        this._clientChain = ImmutableList.of((Object)address);
    }

    public Origin(String host) throws UnknownHostException {
        this._address = InetAddress.getByName(Objects.requireNonNull(host));
        this._clientChain = ImmutableList.of((Object)this._address);
    }

    public Origin(ImmutableList<InetAddress> addresses) {
        Preconditions.checkArgument((!addresses.isEmpty() ? 1 : 0) != 0, (Object)"Empty client chain");
        this._address = (InetAddress)addresses.get(0);
        this._clientChain = addresses;
    }

    public InetAddress getAddress() {
        return this._address;
    }

    public ImmutableList<InetAddress> getClientChain() {
        return this._clientChain == null ? ImmutableList.of((Object)this._address) : this._clientChain;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getName() + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Origin)) {
            return false;
        }
        Origin other = (Origin)o;
        return this.getClientChain().equals(other.getClientChain());
    }

    @Override
    public String getName() {
        if (this._clientChain == null || this._clientChain.size() == 1) {
            return InetAddresses.toAddrString((InetAddress)this._address);
        }
        StringBuilder sb = new StringBuilder();
        UnmodifiableIterator i = this._clientChain.iterator();
        while (true) {
            sb.append(InetAddresses.toAddrString((InetAddress)((InetAddress)i.next())));
            if (!i.hasNext()) {
                return sb.toString();
            }
            sb.append(',');
        }
    }

    @Override
    public int hashCode() {
        return this._address.hashCode();
    }
}

