/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.auth;

import java.io.Serializable;
import org.dcache.util.Strings;

public class PasswordCredential
implements Serializable {
    private static final long serialVersionUID = -8823304503972043526L;
    private final String _username;
    private final String _password;

    public PasswordCredential(String username, String password) {
        this._username = username;
        this._password = password;
    }

    public String getUsername() {
        return this._username;
    }

    public String getPassword() {
        return this._password;
    }

    public String describeCredential() {
        return "username=" + this._username + ",password={Hash:" + Strings.base64Hash(this._password) + "}";
    }

    public int hashCode() {
        return this._username.hashCode() ^ this._password.hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PasswordCredential)) {
            return false;
        }
        PasswordCredential other = (PasswordCredential)o;
        return this._username.equals(other._username) && this._password.equals(other._password);
    }

    public String toString() {
        return PasswordCredential.class.getSimpleName() + "[" + this.describeCredential() + "]";
    }
}

