/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.auth;

import com.google.common.base.Preconditions;
import com.google.common.net.InetAddresses;
import com.sun.security.auth.UnixNumericGroupPrincipal;
import com.sun.security.auth.UnixNumericUserPrincipal;
import eu.emi.security.authn.x509.impl.OpensslNameUtils;
import eu.emi.security.authn.x509.proxy.ProxyUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.Principal;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosPrincipal;
import org.dcache.auth.BearerTokenCredential;
import org.dcache.auth.DesiredRole;
import org.dcache.auth.EmailAddressPrincipal;
import org.dcache.auth.EntityDefinitionPrincipal;
import org.dcache.auth.ExemptFromNamespaceChecks;
import org.dcache.auth.FQAN;
import org.dcache.auth.FQANPrincipal;
import org.dcache.auth.FullNamePrincipal;
import org.dcache.auth.GidPrincipal;
import org.dcache.auth.GroupNamePrincipal;
import org.dcache.auth.IGTFPolicyPrincipal;
import org.dcache.auth.IGTFStatusPrincipal;
import org.dcache.auth.LoAPrincipal;
import org.dcache.auth.LoginGidPrincipal;
import org.dcache.auth.LoginNamePrincipal;
import org.dcache.auth.LoginUidPrincipal;
import org.dcache.auth.MacaroonPrincipal;
import org.dcache.auth.OidcSubjectPrincipal;
import org.dcache.auth.OpenIdGroupPrincipal;
import org.dcache.auth.Origin;
import org.dcache.auth.PasswordCredential;
import org.dcache.auth.UidPrincipal;
import org.dcache.auth.UserAuthBase;
import org.dcache.auth.UserAuthRecord;
import org.dcache.auth.UserNamePrincipal;
import org.dcache.util.PrincipalSetMaker;
import org.globus.gsi.gssapi.jaas.GlobusPrincipal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Subjects {
    private static final Logger LOGGER = LoggerFactory.getLogger(Subjects.class);
    public static final String UNKNOWN = "<unknown>";
    private static final Class<? extends Principal>[] DISPLAYABLE = new Class[]{FullNamePrincipal.class, UserNamePrincipal.class, GlobusPrincipal.class, KerberosPrincipal.class, Origin.class, Principal.class};
    public static final Subject ROOT = new Subject();
    public static final Subject NOBODY;

    public static boolean isRoot(Subject subject) {
        return Subjects.hasUid(subject, 0L);
    }

    public static boolean isExemptFromNamespaceChecks(Subject subject) {
        return subject.getPrincipals().stream().anyMatch(p -> p instanceof UidPrincipal && ((UidPrincipal)p).getUid() == 0L || p instanceof ExemptFromNamespaceChecks);
    }

    public static boolean isNobody(Subject subject) {
        for (Principal principal : subject.getPrincipals()) {
            if (!(principal instanceof UidPrincipal)) continue;
            return false;
        }
        return true;
    }

    public static boolean hasUid(Subject subject, long uid) {
        Set<UidPrincipal> principals = subject.getPrincipals(UidPrincipal.class);
        for (UidPrincipal principal : principals) {
            if (principal.getUid() != uid) continue;
            return true;
        }
        return false;
    }

    public static boolean hasGid(Subject subject, long gid) {
        Set<GidPrincipal> principals = subject.getPrincipals(GidPrincipal.class);
        for (GidPrincipal principal : principals) {
            if (principal.getGid() != gid) continue;
            return true;
        }
        return false;
    }

    public static long[] getUids(Subject subject) {
        Set<UidPrincipal> principals = subject.getPrincipals(UidPrincipal.class);
        long[] uids = new long[principals.size()];
        int i = 0;
        for (UidPrincipal principal : principals) {
            uids[i++] = principal.getUid();
        }
        return uids;
    }

    private static <T> T getUniquePrincipal(Subject subject, Class<T> type) throws IllegalArgumentException {
        T result = null;
        if (subject == null) {
            return null;
        }
        for (Principal principal : subject.getPrincipals()) {
            if (!type.isInstance(principal)) continue;
            if (result != null) {
                throw new IllegalArgumentException("Subject has multiple principals of type " + type.getSimpleName());
            }
            result = type.cast(principal);
        }
        return result;
    }

    public static long getUid(Subject subject) throws NoSuchElementException, IllegalArgumentException {
        UidPrincipal uid = Subjects.getUniquePrincipal(subject, UidPrincipal.class);
        if (uid == null) {
            throw new NoSuchElementException("Subject has no UID");
        }
        return uid.getUid();
    }

    public static long[] getGids(Subject subject) {
        Set<GidPrincipal> principals = subject.getPrincipals(GidPrincipal.class);
        long[] gids = new long[principals.size()];
        int i = 0;
        for (GidPrincipal principal : principals) {
            if (principal.isPrimaryGroup()) {
                gids[i++] = gids[0];
                gids[0] = principal.getGid();
                continue;
            }
            gids[i++] = principal.getGid();
        }
        return gids;
    }

    public static long getPrimaryGid(Subject subject) throws NoSuchElementException, IllegalArgumentException {
        Set<GidPrincipal> principals = subject.getPrincipals(GidPrincipal.class);
        int counter = 0;
        long gid = 0L;
        for (GidPrincipal principal : principals) {
            if (!principal.isPrimaryGroup()) continue;
            gid = principal.getGid();
            ++counter;
        }
        if (counter == 0) {
            throw new NoSuchElementException("Subject has no primary GID");
        }
        if (counter > 1) {
            throw new IllegalArgumentException("Subject has multiple primary GIDs");
        }
        return gid;
    }

    public static Origin getOrigin(Subject subject) throws IllegalArgumentException {
        return Subjects.getUniquePrincipal(subject, Origin.class);
    }

    public static String getDn(Subject subject) throws IllegalArgumentException {
        GlobusPrincipal principal = Subjects.getUniquePrincipal(subject, GlobusPrincipal.class);
        return principal == null ? null : principal.getName();
    }

    public static FQAN getPrimaryFqan(Subject subject) throws IllegalArgumentException {
        Set<FQANPrincipal> principals = subject.getPrincipals(FQANPrincipal.class);
        FQAN fqan = null;
        for (FQANPrincipal principal : principals) {
            if (!principal.isPrimaryGroup()) continue;
            if (fqan != null) {
                throw new IllegalArgumentException("Subject has multiple primary FQANs");
            }
            fqan = principal.getFqan();
        }
        return fqan;
    }

    public static Collection<FQAN> getFqans(Subject subject) {
        ArrayList<FQAN> fqans = new ArrayList<FQAN>();
        for (Principal principal : subject.getPrincipals()) {
            if (!(principal instanceof FQANPrincipal)) continue;
            fqans.add(((FQANPrincipal)principal).getFqan());
        }
        return fqans;
    }

    public static String getUserName(Subject subject) {
        UserNamePrincipal principal = Subjects.getUniquePrincipal(subject, UserNamePrincipal.class);
        return principal == null ? null : principal.getName();
    }

    public static String getLoginName(Subject subject) {
        LoginNamePrincipal principal = Subjects.getUniquePrincipal(subject, LoginNamePrincipal.class);
        return principal == null ? null : principal.getName();
    }

    public static String getDisplayName(Subject subject) {
        for (Class<? extends Principal> clazz : DISPLAYABLE) {
            Set<? extends Principal> principals = subject.getPrincipals(clazz);
            if (principals.isEmpty()) continue;
            return principals.iterator().next().getName();
        }
        return UNKNOWN;
    }

    @Nullable
    public static <T extends Principal> String getPrincipalNames(Subject subject, Class<T> type) {
        Set<T> p = subject.getPrincipals(type);
        return p.isEmpty() ? null : p.stream().map(Principal::getName).collect(Collectors.joining(","));
    }

    public static String getKerberosName(Subject subject) throws IllegalArgumentException {
        KerberosPrincipal principal = Subjects.getUniquePrincipal(subject, KerberosPrincipal.class);
        return principal == null ? null : principal.getName();
    }

    public static List<String> getEmailAddresses(Subject subject) {
        return subject.getPrincipals(EmailAddressPrincipal.class).stream().map(EmailAddressPrincipal::getName).sorted().collect(Collectors.toList());
    }

    public static final Subject getSubject(UserAuthBase user, boolean primary) {
        String fqan;
        String dn;
        Subject subject = new Subject();
        Set<Principal> principals = subject.getPrincipals();
        principals.add(new UidPrincipal(user.UID));
        boolean isPrimary = primary;
        for (int gid : user.GIDs) {
            principals.add(new GidPrincipal(gid, isPrimary));
            isPrimary = false;
        }
        String name = user.Username;
        if (name != null && !name.isEmpty()) {
            principals.add(new UserNamePrincipal(name));
        }
        if ((dn = user.DN) != null && !dn.isEmpty()) {
            principals.add(new GlobusPrincipal(dn));
        }
        if ((fqan = user.getFqan().toString()) != null && !fqan.isEmpty()) {
            principals.add(new FQANPrincipal(fqan, primary));
        }
        return subject;
    }

    public static final Subject getSubject(UserAuthRecord user) {
        String fqanstr;
        FQAN fqan;
        String dn;
        Subject subject = new Subject();
        Set<Principal> principals = subject.getPrincipals();
        principals.add(new UidPrincipal(user.UID));
        boolean primary = true;
        Iterator iterator = user.GIDs.iterator();
        while (iterator.hasNext()) {
            int gid = (Integer)iterator.next();
            principals.add(new GidPrincipal(gid, primary));
            primary = false;
        }
        String name = user.Username;
        if (name != null && !name.isEmpty()) {
            principals.add(new UserNamePrincipal(name));
        }
        if ((dn = user.DN) != null && !dn.isEmpty()) {
            principals.add(new GlobusPrincipal(dn));
        }
        if ((fqan = user.getFqan()) != null && (fqanstr = fqan.toString()) != null && !fqanstr.isEmpty()) {
            principals.add(new FQANPrincipal(fqanstr, true));
        }
        return subject;
    }

    public static Subject subjectFromArgs(List<String> args) {
        Set<Principal> principals = Subjects.principalsFromArgs(args);
        Set publicCredentials = Collections.emptySet();
        Set privateCredentials = Collections.emptySet();
        return new Subject(false, principals, publicCredentials, privateCredentials);
    }

    public static Set<Principal> principalsFromArgs(List<String> args) {
        HashSet<Principal> principals = new HashSet<Principal>();
        boolean isPrimaryFqan = true;
        boolean isPrimaryGid = true;
        for (String arg : args) {
            Principal principal;
            int idx = arg.indexOf(58);
            if (idx == -1) {
                throw new IllegalArgumentException("format for principals is <type>:<value>");
            }
            String type = arg.substring(0, idx);
            String value = arg.substring(idx + 1);
            switch (type) {
                case "dn": {
                    principal = new GlobusPrincipal(value);
                    break;
                }
                case "gid": {
                    principal = new GidPrincipal(value, isPrimaryGid);
                    isPrimaryGid = false;
                    break;
                }
                case "kerberos": {
                    principal = new KerberosPrincipal(value);
                    break;
                }
                case "fqan": {
                    principal = new FQANPrincipal(value, isPrimaryFqan);
                    isPrimaryFqan = false;
                    break;
                }
                case "name": {
                    principal = new LoginNamePrincipal(value);
                    break;
                }
                case "origin": {
                    principal = new Origin(InetAddresses.forString((String)value));
                    break;
                }
                case "oidc": {
                    int atIndex = value.lastIndexOf(64);
                    Preconditions.checkArgument((atIndex != -1 ? 1 : 0) != 0, (Object)"format for 'oidc' principals is <value>@<OP>");
                    String oidcClaim = value.substring(0, atIndex);
                    String op = value.substring(atIndex + 1);
                    principal = new OidcSubjectPrincipal(oidcClaim, op);
                    break;
                }
                case "email": {
                    principal = new EmailAddressPrincipal(value);
                    break;
                }
                case "uid": {
                    principal = new UidPrincipal(value);
                    break;
                }
                case "user": {
                    LOGGER.warn("Please use \"username:{}\" instead of \"{}\"", (Object)value, (Object)arg);
                }
                case "username": {
                    principal = new UserNamePrincipal(value);
                    break;
                }
                case "group": {
                    boolean isPrimary = value.startsWith("!");
                    if (isPrimary) {
                        value = value.substring(1);
                    }
                    principal = new GroupNamePrincipal(value, isPrimary);
                    break;
                }
                default: {
                    try {
                        Class<Principal> principalClass = Class.forName(type).asSubclass(Principal.class);
                        Constructor<Principal> principalConstructor = principalClass.getConstructor(String.class);
                        principal = principalConstructor.newInstance(value);
                        break;
                    }
                    catch (NoSuchMethodException e) {
                        throw new IllegalArgumentException("No matching constructor found: " + type + "(String)");
                    }
                    catch (ClassNotFoundException e) {
                        throw new IllegalArgumentException("No matching class found: " + type);
                    }
                    catch (InvocationTargetException e) {
                        throw new IllegalArgumentException("Invocation failed: " + e.toString());
                    }
                    catch (InstantiationException e) {
                        throw new IllegalArgumentException("Instantiation failed: " + e.toString());
                    }
                    catch (IllegalAccessException e) {
                        throw new IllegalArgumentException("Access Exception: " + e.toString());
                    }
                }
            }
            principals.add(principal);
        }
        return principals;
    }

    public static String toString(Subject subject) {
        StringBuilder sb = new StringBuilder();
        for (Object credential : subject.getPublicCredentials()) {
            Subjects.appendComma(sb);
            if (credential instanceof CertPath) {
                List<? extends Certificate> certificates = ((CertPath)credential).getCertificates();
                X509Certificate[] chain = (X509Certificate[])certificates.toArray(X509Certificate[]::new);
                Subjects.appendX509Array(sb, chain);
                continue;
            }
            if (credential instanceof X509Certificate[]) {
                Subjects.appendX509Array(sb, (X509Certificate[])credential);
                continue;
            }
            Subjects.appendOptionallyInQuotes(sb, credential.toString());
        }
        for (Object credential : subject.getPrivateCredentials()) {
            Subjects.appendComma(sb);
            if (credential instanceof PasswordCredential) {
                String description = ((PasswordCredential)credential).describeCredential();
                sb.append("username-with-password:");
                Subjects.appendOptionallyInQuotes(sb, description);
                continue;
            }
            if (credential instanceof BearerTokenCredential) {
                String token = ((BearerTokenCredential)credential).describeToken();
                sb.append("bearer-token:");
                Subjects.appendOptionallyInQuotes(sb, token);
                continue;
            }
            Subjects.appendOptionallyInQuotes(sb, credential.toString());
        }
        for (Principal principal : subject.getPrincipals()) {
            Object label;
            Subjects.appendComma(sb);
            if (principal instanceof GlobusPrincipal) {
                sb.append("dn:");
                Subjects.appendOptionallyInQuotes(sb, principal.getName());
                continue;
            }
            if (principal instanceof KerberosPrincipal) {
                sb.append("kerberos:");
                Subjects.appendOptionallyInQuotes(sb, principal.getName());
                continue;
            }
            if (principal instanceof FQANPrincipal) {
                sb.append("fqan:");
                label = ((FQANPrincipal)principal).isPrimaryGroup() ? "!" + principal.getName() : principal.getName();
                Subjects.appendOptionallyInQuotes(sb, (String)label);
                continue;
            }
            if (principal instanceof LoginNamePrincipal) {
                sb.append("desired-username:");
                Subjects.appendOptionallyInQuotes(sb, principal.getName());
                continue;
            }
            if (principal instanceof Origin) {
                sb.append("origin:");
                Subjects.appendOptionallyInQuotes(sb, principal.getName());
                continue;
            }
            if (principal instanceof OidcSubjectPrincipal) {
                sb.append("oidc:");
                Subjects.appendOptionallyInQuotes(sb, principal.getName());
                continue;
            }
            if (principal instanceof EmailAddressPrincipal) {
                sb.append("email:");
                Subjects.appendOptionallyInQuotes(sb, principal.getName());
                continue;
            }
            if (principal instanceof UserNamePrincipal) {
                sb.append("user:");
                Subjects.appendOptionallyInQuotes(sb, principal.getName());
                continue;
            }
            if (principal instanceof GroupNamePrincipal) {
                sb.append("group:");
                label = ((GroupNamePrincipal)principal).isPrimaryGroup() ? "!" + principal.getName() : principal.getName();
                Subjects.appendOptionallyInQuotes(sb, (String)label);
                continue;
            }
            if (principal instanceof UidPrincipal) {
                sb.append("uid:").append(((UidPrincipal)principal).getUid());
                continue;
            }
            if (principal instanceof GidPrincipal) {
                sb.append("gid:");
                if (((GidPrincipal)principal).isPrimaryGroup()) {
                    sb.append('!');
                }
                sb.append(principal.getName());
                continue;
            }
            if (principal instanceof DesiredRole) {
                sb.append("desired-role:");
                Subjects.appendOptionallyInQuotes(sb, principal.getName());
                continue;
            }
            if (principal instanceof EntityDefinitionPrincipal) {
                sb.append("entity-defn:").append(principal.getName());
                continue;
            }
            if (principal instanceof FullNamePrincipal) {
                sb.append("full-name:");
                Subjects.appendOptionallyInQuotes(sb, principal.getName());
                continue;
            }
            if (principal instanceof IGTFPolicyPrincipal) {
                sb.append("IGTF-policy:");
                Subjects.appendOptionallyInQuotes(sb, principal.getName());
                continue;
            }
            if (principal instanceof IGTFStatusPrincipal) {
                sb.append("IGTF-status:");
                Subjects.appendOptionallyInQuotes(sb, principal.getName());
                continue;
            }
            if (principal instanceof LoAPrincipal) {
                sb.append("LoA:");
                Subjects.appendOptionallyInQuotes(sb, principal.getName());
                continue;
            }
            if (principal instanceof LoginGidPrincipal) {
                sb.append("desired-gid:").append(((LoginGidPrincipal)principal).getGid());
                continue;
            }
            if (principal instanceof LoginUidPrincipal) {
                sb.append("desired-uid:").append(((LoginUidPrincipal)principal).getUid());
                continue;
            }
            if (principal instanceof MacaroonPrincipal) {
                sb.append("macaroon:");
                Subjects.appendOptionallyInQuotes(sb, principal.getName());
                continue;
            }
            if (principal instanceof OpenIdGroupPrincipal) {
                sb.append("oidc-group:");
                Subjects.appendOptionallyInQuotes(sb, principal.getName());
                continue;
            }
            if (principal instanceof Origin) {
                sb.append("origin:").append(principal.getName());
                continue;
            }
            sb.append(principal.getClass().getSimpleName()).append(':');
            Subjects.appendOptionallyInQuotes(sb, principal.getName());
        }
        return "{" + sb + "}";
    }

    private static StringBuilder appendX509Array(StringBuilder sb, X509Certificate[] chain) {
        X509Certificate eec = ProxyUtils.getEndUserCertificate((X509Certificate[])chain);
        String dn = OpensslNameUtils.convertFromRfc2253((String)eec.getSubjectX500Principal().getName(), (boolean)true);
        sb.append(ProxyUtils.isProxy((X509Certificate[])chain) ? "proxy" : "x509").append("-chain:");
        Subjects.appendOptionallyInQuotes(sb, dn);
        return sb;
    }

    private static StringBuilder appendComma(StringBuilder sb) {
        if (sb.length() > 0) {
            sb.append(", ");
        }
        return sb;
    }

    private static StringBuilder appendOptionallyInQuotes(StringBuilder sb, String argument) {
        if (argument.contains(" ")) {
            sb.append('\"').append(argument).append('\"');
        } else {
            sb.append(argument);
        }
        return sb;
    }

    public static Subject of(int uid, int gid, int[] gids) {
        Builder builder = Subjects.of().uid(uid).gid(gid);
        for (int g : gids) {
            builder.gid(g);
        }
        return builder.build();
    }

    public static Builder of() {
        return new Builder();
    }

    public static Subject ofPrincipals(Set<Principal> principals) {
        Subject subject = new Subject();
        subject.getPrincipals().addAll(principals);
        return subject;
    }

    public static Subject of(PrincipalSetMaker maker) {
        return Subjects.ofPrincipals(maker.build());
    }

    public static Subject fromUnixNumericSubject(Subject s) {
        Set<Principal> principals = s.getPrincipals();
        HashSet outPrincipals = new HashSet();
        principals.forEach(p -> {
            if (p instanceof UnixNumericUserPrincipal) {
                UnixNumericUserPrincipal up = (UnixNumericUserPrincipal)p;
                p = new UidPrincipal(up.longValue());
            } else if (p instanceof UnixNumericGroupPrincipal) {
                UnixNumericGroupPrincipal up = (UnixNumericGroupPrincipal)p;
                p = new GidPrincipal(up.longValue(), up.isPrimaryGroup());
            }
            outPrincipals.add(p);
        });
        return new Subject(s.isReadOnly(), outPrincipals, s.getPublicCredentials(), s.getPrivateCredentials());
    }

    static {
        ROOT.getPrincipals().add(new UidPrincipal(0L));
        ROOT.getPrincipals().add(new GidPrincipal(0L, true));
        ROOT.setReadOnly();
        NOBODY = new Subject();
        NOBODY.setReadOnly();
    }

    public static class Builder {
        private final Subject _subject = new Subject();
        private boolean haveFqan;
        private boolean haveGid;
        private boolean readOnly;

        public Subject build() {
            if (this.readOnly) {
                this._subject.setReadOnly();
            }
            return this._subject;
        }

        private void add(Principal principal) {
            this._subject.getPrincipals().add(principal);
        }

        public Builder readOnly() {
            this.readOnly = true;
            return this;
        }

        public Builder dn(String dn) {
            this.add(new GlobusPrincipal(dn));
            return this;
        }

        public Builder uid(long uid) {
            this.add(new UidPrincipal(uid));
            return this;
        }

        public Builder gid(long gid) {
            this.add(new GidPrincipal(gid, !this.haveGid));
            this.haveGid = true;
            return this;
        }

        public Builder fqan(String fqan) {
            return this.fqan(new FQAN(fqan));
        }

        public Builder fqan(FQAN fqan) {
            this.add(new FQANPrincipal(fqan, !this.haveFqan));
            this.haveFqan = true;
            return this;
        }

        public Builder username(String name) {
            this.add(new UserNamePrincipal(name));
            return this;
        }
    }
}

