/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.auth;

import org.dcache.auth.UserAuthBase;

public class UserPwdRecord
extends UserAuthBase {
    private static final long serialVersionUID = 1335892861480300575L;
    String Password;

    public UserPwdRecord(String user, String passwd, boolean readOnly, int uid, int[] gid, String home, String root, String fsroot) {
        this(user, passwd, readOnly, uid, gid, home, root, fsroot, false);
    }

    public UserPwdRecord(String user, String passwd, boolean readOnly, int uid, int[] gid, String home, String root, String fsroot, boolean isPlain) {
        super(user, readOnly, uid, gid, home, root, fsroot);
        if (isPlain) {
            this.setPassword(passwd);
        } else {
            this.Password = passwd;
        }
    }

    public UserPwdRecord(String user, String passwd, boolean readOnly, int uid, int gid, String home, String root, String fsroot) {
        this(user, passwd, readOnly, uid, gid, home, root, fsroot, false);
    }

    public UserPwdRecord(String user, String passwd, boolean readOnly, int uid, int gid, String home, String root, String fsroot, boolean isPlain) {
        super(user, readOnly, uid, gid, home, root, fsroot);
        if (isPlain) {
            this.setPassword(passwd);
        } else {
            this.Password = passwd;
        }
    }

    @Override
    public boolean isWeak() {
        return true;
    }

    public String toString() {
        String str = this.Username + " " + this.readOnlyStr() + " " + this.UID + " " + this.GIDs + " " + this.Home + " " + this.Root;
        if (!this.Root.equals(this.FsRoot)) {
            str = str + " " + this.FsRoot;
        }
        return str;
    }

    public String toDetailedString() {
        String stringbuffer = " User Password Record for " + this.Username + " :\n  Password Hash = " + this.Password + "\n      read-only = " + this.readOnlyStr() + "\n            UID = " + this.UID + "\n           GIDs = " + this.GIDs + "\n           Home = " + this.Home + "\n           Root = " + this.Root + "\n         FsRoot = " + this.FsRoot + "\n";
        return stringbuffer;
    }

    public String hashPassword(String pwd) {
        String uandp = "1234567890" + this.Username + " " + pwd;
        return Integer.toHexString(uandp.hashCode());
    }

    public void setPassword(String pwd) {
        this.Password = pwd.equals("-") ? "-" : this.hashPassword(pwd);
    }

    public void disable() {
        this.Password = "#";
    }

    public boolean passwordIsValid(String clear_pwd) {
        return this.Password.equals(this.hashPassword(clear_pwd));
    }

    public boolean isDisabled() {
        return this.Password.equals("#");
    }

    @Override
    public boolean isAnonymous() {
        return this.Password.equals("-");
    }

    public boolean isValid() {
        return this.Username != null && this.Password != null;
    }
}

