/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.auth.attributes;

import diskCacheV111.util.FsPath;
import java.util.Collection;
import java.util.OptionalLong;
import java.util.stream.Stream;
import org.dcache.auth.attributes.LoginAttribute;
import org.dcache.auth.attributes.MaxUploadSize;
import org.dcache.auth.attributes.Role;
import org.dcache.auth.attributes.RootDirectory;
import org.dcache.auth.attributes.UnassertedRole;

public class LoginAttributes {
    public static final String ADMIN_ROLE_NAME = "admin";
    public static final String OBSERVER_ROLE_NAME = "observer";
    private static final Role ADMIN_ROLE = new Role("admin");
    private static final Role OBSERVER_ROLE = new Role("observer");

    private LoginAttributes() {
    }

    public static FsPath getUserRoot(Collection<LoginAttribute> attributes) {
        FsPath root = FsPath.ROOT;
        for (LoginAttribute attribute : attributes) {
            if (attribute.equals(ADMIN_ROLE) || attribute.equals(OBSERVER_ROLE)) {
                return FsPath.ROOT;
            }
            if (!(attribute instanceof RootDirectory)) continue;
            root = FsPath.create(((RootDirectory)attribute).getRoot());
        }
        return root;
    }

    public static Role adminRole() {
        return ADMIN_ROLE;
    }

    public static Role observerRole() {
        return OBSERVER_ROLE;
    }

    public static boolean hasAdminRole(Collection<LoginAttribute> attributes) {
        return attributes.stream().anyMatch(ADMIN_ROLE::equals);
    }

    public static boolean hasObserverRole(Collection<LoginAttribute> attributes) {
        return attributes.stream().anyMatch(OBSERVER_ROLE::equals);
    }

    public static Stream<String> assertedRoles(Collection<LoginAttribute> attributes) {
        return attributes.stream().filter(Role.class::isInstance).map(Role.class::cast).map(Role::getRole);
    }

    public static Stream<String> unassertedRoles(Collection<LoginAttribute> attributes) {
        return attributes.stream().filter(UnassertedRole.class::isInstance).map(UnassertedRole.class::cast).map(UnassertedRole::getRole);
    }

    public static OptionalLong maximumUploadSize(Collection<LoginAttribute> attributes) {
        return attributes.stream().filter(MaxUploadSize.class::isInstance).map(MaxUploadSize.class::cast).mapToLong(a -> a.getMaximumSize()).min();
    }
}

