/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.auth.attributes;

import com.google.common.collect.ComparisonChain;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Ordering;
import diskCacheV111.util.FsPath;
import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.stream.Collectors;
import org.dcache.auth.attributes.Activity;
import org.dcache.auth.attributes.Restriction;

public class MultiTargetedRestriction
implements Restriction {
    private static final EnumSet<Activity> ALLOWED_PARENT_ACTIVITIES = EnumSet.of(Activity.LIST, Activity.READ_METADATA);
    private final Collection<Authorisation> authorisations;

    public MultiTargetedRestriction(Collection<Authorisation> authorisations) {
        this.authorisations = (Collection)authorisations.stream().sorted().collect(ImmutableList.toImmutableList());
    }

    @Override
    public boolean hasUnrestrictedChild(Activity activity, FsPath parent) {
        for (Authorisation authorisation : this.authorisations) {
            FsPath allowedPath = authorisation.getPath();
            EnumSet<Activity> allowedActivity = authorisation.getActivity();
            if (!allowedActivity.contains((Object)activity) || !allowedPath.hasPrefix(parent) && !parent.hasPrefix(allowedPath)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isRestricted(Activity activity, FsPath path) {
        for (Authorisation authorisation : this.authorisations) {
            FsPath allowedPath = authorisation.getPath();
            EnumSet<Activity> allowedActivity = authorisation.getActivity();
            if (allowedActivity.contains((Object)activity) && path.hasPrefix(allowedPath)) {
                return false;
            }
            if (!ALLOWED_PARENT_ACTIVITIES.contains((Object)activity) || !allowedPath.hasPrefix(path)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isRestricted(Activity activity, FsPath directory, String child) {
        return this.isRestricted(activity, directory.child(child));
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof MultiTargetedRestriction)) {
            return false;
        }
        return ((MultiTargetedRestriction)other).authorisations.equals(this.authorisations);
    }

    public int hashCode() {
        return this.authorisations.hashCode();
    }

    private boolean subsumes(MultiTargetedRestriction other) {
        return this.authorisations.stream().allMatch(ap -> other.hasAuthorisationSubsumedBy((Authorisation)ap));
    }

    private boolean hasAuthorisationSubsumedBy(Authorisation other) {
        EnumSet<Activity> disallowedOtherActivities = EnumSet.complementOf(other.activities);
        return this.authorisations.stream().anyMatch(ap -> disallowedOtherActivities.containsAll(EnumSet.complementOf(ap.activities)) && other.getPath().hasPrefix(ap.getPath()));
    }

    @Override
    public boolean isSubsumedBy(Restriction other) {
        if (other instanceof MultiTargetedRestriction) {
            return ((MultiTargetedRestriction)other).subsumes(this);
        }
        return false;
    }

    @Override
    public String toString() {
        return this.authorisations.stream().map(Object::toString).collect(Collectors.joining(", ", "MultiTargetedRestriction[", "]"));
    }

    public static class Authorisation
    implements Serializable,
    Comparable<Authorisation> {
        private static final long serialVersionUID = 1L;
        private final EnumSet<Activity> activities;
        private final FsPath path;

        public Authorisation(Collection<Activity> activities, FsPath path) {
            this.activities = EnumSet.copyOf(activities);
            this.path = path;
        }

        public EnumSet<Activity> getActivity() {
            return this.activities;
        }

        public FsPath getPath() {
            return this.path;
        }

        public int hashCode() {
            return this.activities.hashCode() ^ this.path.hashCode();
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (!(other instanceof Authorisation)) {
                return false;
            }
            Authorisation otherAuthorisation = (Authorisation)other;
            return otherAuthorisation.activities.equals(this.activities) && otherAuthorisation.path.equals(this.path);
        }

        @Override
        public int compareTo(Authorisation other) {
            return ComparisonChain.start().compare((Object)this.path, (Object)other.path, (Comparator)Ordering.usingToString()).compare(this.activities, other.activities, (Comparator)Ordering.natural().lexicographical()).result();
        }

        public String toString() {
            return "Authorisation{allowing " + this.activities + " on " + this.path + "}";
        }
    }
}

