/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.auth.attributes;

import diskCacheV111.util.FsPath;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.dcache.auth.attributes.Activity;
import org.dcache.auth.attributes.DenyActivityRestriction;
import org.dcache.auth.attributes.Restriction;

public class Restrictions {
    private static final Restriction UNRESTRICTED = DenyActivityRestriction.restrictNoActivity();
    private static final Restriction DENY_ALL = DenyActivityRestriction.restrictAllActivity();
    private static final Restriction READ_ONLY = new DenyActivityRestriction(Activity.DELETE, Activity.MANAGE, Activity.UPDATE_METADATA, Activity.UPLOAD);

    private Restrictions() {
    }

    public static Restriction denyAll() {
        return DENY_ALL;
    }

    public static Restriction none() {
        return UNRESTRICTED;
    }

    public static Restriction readOnly() {
        return READ_ONLY;
    }

    public static Restriction concat(Restriction ... restrictions) {
        switch (restrictions.length) {
            case 0: {
                return UNRESTRICTED;
            }
            case 1: {
                return restrictions[0];
            }
            case 2: {
                if (restrictions[0].isSubsumedBy(restrictions[1])) {
                    return restrictions[1];
                }
                if (!restrictions[1].isSubsumedBy(restrictions[0])) break;
                return restrictions[0];
            }
        }
        return Restrictions.concat(Arrays.asList(restrictions));
    }

    public static Restriction concat(Iterable<Restriction> restrictions) {
        CompositeRestrictionBuilder composer = new CompositeRestrictionBuilder();
        for (Restriction r : restrictions) {
            if (r instanceof CompositeRestriction) {
                for (Restriction inner : ((CompositeRestriction)r).restrictions) {
                    composer.accept(inner);
                }
                continue;
            }
            composer.accept(r);
        }
        return composer.build();
    }

    private static class CompositeRestriction
    implements Restriction {
        private static final long serialVersionUID = 1854305439062458336L;
        private final Set<Restriction> restrictions;

        public CompositeRestriction(Set<Restriction> restrictions) {
            this.restrictions = restrictions;
        }

        @Override
        public boolean isRestricted(Activity activity, FsPath path) {
            for (Restriction r : this.restrictions) {
                if (!r.isRestricted(activity, path)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isRestricted(Activity activity, FsPath directory, String name) {
            for (Restriction r : this.restrictions) {
                if (!r.isRestricted(activity, directory, name)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean hasUnrestrictedChild(Activity activity, FsPath parent) {
            return !this.restrictions.stream().anyMatch(r -> !r.hasUnrestrictedChild(activity, parent));
        }

        @Override
        public boolean equals(Object other) {
            if (!(other instanceof CompositeRestriction)) {
                return false;
            }
            CompositeRestriction r = (CompositeRestriction)other;
            return this.restrictions.equals(r.restrictions);
        }

        public int hashCode() {
            return Objects.hashCode(this.restrictions);
        }

        @Override
        public boolean isSubsumedBy(Restriction other) {
            if (other instanceof CompositeRestriction) {
                return this.isSubsumedBy((CompositeRestriction)other);
            }
            for (Restriction r : this.restrictions) {
                if (r.isSubsumedBy(other)) continue;
                return false;
            }
            return true;
        }

        private boolean isSubsumedBy(CompositeRestriction other) {
            for (Restriction r : this.restrictions) {
                if (other.subsumes(r)) continue;
                return false;
            }
            return true;
        }

        private boolean subsumes(Restriction other) {
            for (Restriction r : this.restrictions) {
                if (!other.isSubsumedBy(r)) continue;
                return true;
            }
            return false;
        }

        @Override
        public String toString() {
            return this.restrictions.stream().map(Restriction::toString).collect(Collectors.joining(", ", "CompositeRestriction[", "]"));
        }
    }

    private static class CompositeRestrictionBuilder {
        private final Set<Restriction> restrictions = new HashSet<Restriction>();

        private CompositeRestrictionBuilder() {
        }

        private void accept(Restriction newRestriction) {
            Iterator<Restriction> i = this.restrictions.iterator();
            while (i.hasNext()) {
                Restriction existing = i.next();
                if (newRestriction.isSubsumedBy(existing)) {
                    return;
                }
                if (!existing.isSubsumedBy(newRestriction)) continue;
                i.remove();
            }
            this.restrictions.add(newRestriction);
        }

        private Restriction build() {
            switch (this.restrictions.size()) {
                case 0: {
                    return UNRESTRICTED;
                }
                case 1: {
                    return this.restrictions.iterator().next();
                }
            }
            return new CompositeRestriction(this.restrictions);
        }
    }
}

