/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.db;

import com.google.common.collect.ForwardingObject;
import java.io.Closeable;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Objects;
import javax.sql.DataSource;
import org.dcache.alarms.AlarmMarkerFactory;
import org.dcache.alarms.PredefinedAlarm;
import org.dcache.util.NetworkUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlarmEnabledDataSource
extends ForwardingObject
implements DataSource,
Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataSource.class);
    private final DataSource delegate;
    private final String connectorName;
    private final String url;

    public AlarmEnabledDataSource(String url, String connectorName, DataSource delegate) {
        this.connectorName = Objects.requireNonNull(connectorName);
        this.url = Objects.requireNonNull(url);
        this.delegate = Objects.requireNonNull(delegate);
    }

    public DataSource getDelegate() {
        return this.delegate();
    }

    protected DataSource delegate() {
        return this.delegate;
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.delegate().getLogWriter();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isInstance(this.delegate())) {
            return (T)this.delegate();
        }
        return this.delegate().unwrap(iface);
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.delegate().setLogWriter(out);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        if (iface.isInstance(this.delegate())) {
            return true;
        }
        return this.delegate().isWrapperFor(iface);
    }

    @Override
    public Connection getConnection() throws SQLException {
        try {
            return this.delegate().getConnection();
        }
        catch (SQLException sql) {
            LOGGER.error(AlarmMarkerFactory.getMarker(PredefinedAlarm.DB_CONNECTION_FAILURE, this.url, this.connectorName, NetworkUtils.getCanonicalHostName()), "Could not get connection to database", (Throwable)sql);
            throw sql;
        }
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.delegate().setLoginTimeout(seconds);
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        try {
            return this.delegate().getConnection(username, password);
        }
        catch (SQLException sql) {
            LOGGER.error(AlarmMarkerFactory.getMarker(PredefinedAlarm.DB_CONNECTION_FAILURE, this.url, this.connectorName, NetworkUtils.getCanonicalHostName()), "Could not get connection to database", (Throwable)sql);
            throw sql;
        }
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.delegate().getLoginTimeout();
    }

    @Override
    public java.util.logging.Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return this.delegate().getParentLogger();
    }

    @Override
    public void close() throws IOException {
        if (this.delegate() instanceof Closeable) {
            ((Closeable)((Object)this.delegate())).close();
        }
    }
}

